/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.bridge.mapping.util;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.diffmerge.bridge.api.ISymbolProvider;
import org.eclipse.emf.diffmerge.bridge.mapping.Messages;
import org.eclipse.emf.diffmerge.bridge.mapping.api.IQuery;
import org.eclipse.emf.diffmerge.bridge.mapping.api.IQueryExecution;
import org.eclipse.emf.diffmerge.bridge.mapping.api.IRule;
import org.eclipse.emf.diffmerge.bridge.util.AbstractLoggingMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuleLoggingMessage
extends AbstractLoggingMessage {
    private Step _executionStep;
    private IQueryExecution _queryExection;

    public RuleLoggingMessage(ISymbolProvider provider_p) {
        super((Object)provider_p);
    }

    public RuleLoggingMessage(ISymbolProvider provider_p, Step step_p) {
        this(provider_p);
        this._executionStep = step_p;
    }

    public RuleLoggingMessage(ISymbolProvider provider_p, Step step_p, IQueryExecution queryExection_p) {
        this(provider_p, step_p);
        this._queryExection = queryExection_p;
    }

    protected String getAdditionalInfo() {
        if (this.getExecutionStep() != null && this.getExecutionStep() == Step.TargetCreation) {
            return Messages.BridgeLogger_TargetCreationMessageSuffix;
        }
        return Messages.BridgeLogger_TargetDefinitionMessageSuffix;
    }

    protected Step getExecutionStep() {
        return this._executionStep;
    }

    protected String getMessageBody() {
        StringBuilder builder = new StringBuilder();
        Object rule = this.getRuleObject();
        builder.append("[").append(this.getRuleName(rule)).append("]");
        return builder.toString();
    }

    public Collection<?> getObjects() {
        return Collections.emptySet();
    }

    protected String getPrefix() {
        if (this.getExecutionStep() != null && this.getExecutionStep() == Step.TargetCreation) {
            IQuery inputProvider;
            Object rule;
            StringBuilder builder = new StringBuilder();
            builder.append("\t|");
            int depth = 1;
            if (this._queryExection != null && (rule = this.getRuleObject()) instanceof IRule && (inputProvider = ((IRule)rule).getInputProvider()) != null) {
                depth = this._queryExection.getAll().size();
            }
            int i = 0;
            while (i < depth) {
                builder.append("\t|");
                ++i;
            }
            builder.append("  |____Rule ");
            return builder.toString();
        }
        return "\t|__Rule ";
    }

    protected String getRuleName(Object rule_p) {
        if (rule_p.getClass().isAnonymousClass()) {
            return rule_p.getClass().getEnclosingClass().getSimpleName();
        }
        return rule_p.getClass().getSimpleName();
    }

    protected Object getRuleObject() {
        return this.getObjectToLabel().keySet().iterator().next();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Step {
        TargetCreation,
        TargetDefinition;

    }
}

