/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.bridge.util;

import java.util.Collection;
import java.util.LinkedHashSet;
import org.eclipse.emf.diffmerge.bridge.api.ICause;
import org.eclipse.emf.diffmerge.bridge.util.AbstractLoggingMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseTraceLoggingMessage
extends AbstractLoggingMessage {
    protected final ICause<?> _cause;

    public BaseTraceLoggingMessage(Object target_p, ICause<?> cause_p) {
        super(target_p);
        this._cause = cause_p;
    }

    @Override
    protected String getAdditionalInfo() {
        return "";
    }

    public ICause<?> getCause() {
        return this._cause;
    }

    @Override
    protected String getMessageBody() {
        StringBuilder builder = new StringBuilder();
        builder.append("Produced [" + this.getObjectLabel(this.getTarget()) + "]");
        builder.append(" From [");
        builder.append(this.getObjectLabel(this.getCause()));
        builder.append("]");
        return builder.toString();
    }

    @Override
    public Collection<?> getObjects() {
        Collection<?> sourceElements = this.getCause().getSourceElements();
        LinkedHashSet<Object> result = new LinkedHashSet<Object>(sourceElements.size() + 1);
        result.addAll(sourceElements);
        Object target = this.getTarget();
        if (target != null) {
            result.add(target);
        }
        return result;
    }

    @Override
    protected String getPrefix() {
        return "";
    }

    public Object getTarget() {
        return this.getObjectToLabel().keySet().iterator().next();
    }
}

