/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.patterns.diagrams.sirius.operations;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.diffmerge.patterns.diagrams.operations.AbstractPatternWithLayoutOperation;
import org.eclipse.emf.diffmerge.patterns.diagrams.sirius.util.ColorUtil;
import org.eclipse.emf.diffmerge.patterns.diagrams.sirius.util.LayerNavigator;
import org.eclipse.emf.diffmerge.patterns.diagrams.sirius.util.LayoutUtil;
import org.eclipse.emf.diffmerge.patterns.diagrams.sirius.util.SiriusDiagramUtil;
import org.eclipse.emf.diffmerge.patterns.templates.engine.specifications.AbstractModifiableTemplatePatternSpecification;
import org.eclipse.emf.diffmerge.patterns.templates.gen.templatepatterns.EdgeLayout;
import org.eclipse.emf.diffmerge.patterns.templates.gen.templatepatterns.Layout;
import org.eclipse.emf.diffmerge.patterns.templates.gen.templatepatterns.NodeLayout;
import org.eclipse.emf.diffmerge.patterns.templates.gen.templatepatterns.NodeStyle;
import org.eclipse.emf.diffmerge.patterns.templates.gen.templatepatterns.TemplateFontStyle;
import org.eclipse.emf.diffmerge.structures.common.FHashMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.notation.Bendpoints;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.ConnectorStyle;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.FontStyle;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.ShapeStyle;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.ContainerStyle;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DiagramPackage;
import org.eclipse.sirius.diagram.EdgeStyle;
import org.eclipse.sirius.diagram.FlatContainerStyle;
import org.eclipse.sirius.diagram.Square;
import org.eclipse.sirius.diagram.ui.tools.api.editor.DDiagramEditor;
import org.eclipse.sirius.viewpoint.BasicLabelStyle;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.FontFormat;
import org.eclipse.sirius.viewpoint.Style;
import org.eclipse.sirius.viewpoint.ViewpointPackage;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public abstract class SiriusAbstractPatternWithLayoutOperation<T>
extends AbstractPatternWithLayoutOperation<T> {
    public SiriusAbstractPatternWithLayoutOperation(String name_p, AbstractModifiableTemplatePatternSpecification data_p, List<Object> graphicalContext_p, Object patternSideContext_p) {
        super(name_p, data_p, graphicalContext_p, patternSideContext_p);
    }

    public EMap<EObject, Layout> buildLayoutData() {
        FHashMap resultMap = new FHashMap();
        ArrayList<View> notIncludedSemanticElementsViews = new ArrayList<View>();
        for (Object obj : this._graphicalContext) {
            Object gefModel;
            if (!(obj instanceof IGraphicalEditPart) || !((gefModel = ((IGraphicalEditPart)obj).getModel()) instanceof View)) continue;
            View view = (View)gefModel;
            this.getViewLayoutData(view, (EMap<EObject, Layout>)resultMap);
            notIncludedSemanticElementsViews.add(view);
        }
        List<View> allElementsViews = this.addIncludedElementsGMFLayout();
        for (View view : allElementsViews) {
            if (notIncludedSemanticElementsViews.contains(view)) continue;
            this.getViewLayoutData(view, (EMap<EObject, Layout>)resultMap);
        }
        return ECollections.unmodifiableEMap((EMap)resultMap);
    }

    private EdgeLayout buildLayoutDataForEdge(Edge edge_p) {
        EObject siriusElement;
        EdgeLayout result = null;
        SiriusDiagramUtil.LocalEdgeStyle localEdgeStyle = new SiriusDiagramUtil.LocalEdgeStyle();
        SiriusDiagramUtil.LocalFontStyle localEdgeFontStyle = new SiriusDiagramUtil.LocalFontStyle();
        SiriusDiagramUtil.LocalFontStyle localCenterEdgeFontStyle = new SiriusDiagramUtil.LocalFontStyle();
        SiriusDiagramUtil.LocalFontStyle localEndEdgeFontStyle = new SiriusDiagramUtil.LocalFontStyle();
        SiriusDiagramUtil.LocalFontStyle localBeginEdgeFontStyle = new SiriusDiagramUtil.LocalFontStyle();
        List<String> edgeCustomFeatures = LayoutUtil.getEdgeCustomSpecification(edge_p);
        EList styles = edge_p.getStyles();
        for (org.eclipse.gmf.runtime.notation.Style style : styles) {
            if (style instanceof FontStyle) {
                FontStyle fontstyle = (FontStyle)style;
                if (!(edge_p.getElement() instanceof DEdge)) continue;
                DEdge dedge = (DEdge)edge_p.getElement();
                EdgeStyle edgestyle = dedge.getOwnedStyle();
                this.getLocalFontStyleDataFromFont(localEdgeFontStyle, fontstyle);
                if (edgestyle.getCenterLabelStyle() != null) {
                    this.getLocalFontStyleData(localCenterEdgeFontStyle, (BasicLabelStyle)edgestyle.getCenterLabelStyle());
                }
                if (edgestyle.getEndLabelStyle() != null) {
                    this.getLocalFontStyleData(localEndEdgeFontStyle, (BasicLabelStyle)edgestyle.getEndLabelStyle());
                }
                if (edgestyle.getBeginLabelStyle() == null) continue;
                this.getLocalFontStyleData(localBeginEdgeFontStyle, (BasicLabelStyle)edgestyle.getBeginLabelStyle());
                continue;
            }
            if (!(style instanceof ConnectorStyle)) continue;
            ConnectorStyle connectorStyle = (ConnectorStyle)style;
            this.getLocalEdgeStyleDataFromConnector(localEdgeStyle, connectorStyle, edgeCustomFeatures);
        }
        Bendpoints bendpoints = edge_p.getBendpoints();
        if (bendpoints != null && (siriusElement = edge_p.getElement()) instanceof DEdge) {
            DEdge dedge = (DEdge)siriusElement;
            EdgeStyle edgestyle = dedge.getOwnedStyle();
            this.getLocalEdgeStyleData(localEdgeStyle, edgestyle, (EList<String>)edgestyle.getCustomFeatures());
            TemplateFontStyle templateFontStyle = LayoutUtil.toTemplateFontStyle(localEdgeFontStyle.selectedFontColor, localEdgeFontStyle.selectedFontName, localEdgeFontStyle.selectedFontHeight, localEdgeFontStyle.selectedIsBold, localEdgeFontStyle.selectedIsItalic, localEdgeFontStyle.selectedIsUnderline, localEdgeFontStyle.selectedIsStrikeThrough);
            LayoutUtil.adjustTemplateFontStyleWithSiriusElement(templateFontStyle, (DSemanticDecorator)dedge);
            TemplateFontStyle centerEdgeFontStyle = LayoutUtil.toTemplateFontStyle(localCenterEdgeFontStyle.selectedFontColor, localCenterEdgeFontStyle.selectedFontName, localCenterEdgeFontStyle.selectedFontHeight, localCenterEdgeFontStyle.selectedIsBold, localCenterEdgeFontStyle.selectedIsItalic, localCenterEdgeFontStyle.selectedIsUnderline, localCenterEdgeFontStyle.selectedIsStrikeThrough);
            TemplateFontStyle endEdgeFontStyle = LayoutUtil.toTemplateFontStyle(localEndEdgeFontStyle.selectedFontColor, localEndEdgeFontStyle.selectedFontName, localEndEdgeFontStyle.selectedFontHeight, localEndEdgeFontStyle.selectedIsBold, localEndEdgeFontStyle.selectedIsItalic, localEndEdgeFontStyle.selectedIsUnderline, localEndEdgeFontStyle.selectedIsStrikeThrough);
            TemplateFontStyle beginEdgeFontStyle = LayoutUtil.toTemplateFontStyle(localBeginEdgeFontStyle.selectedFontColor, localBeginEdgeFontStyle.selectedFontName, localBeginEdgeFontStyle.selectedFontHeight, localBeginEdgeFontStyle.selectedIsBold, localBeginEdgeFontStyle.selectedIsItalic, localBeginEdgeFontStyle.selectedIsUnderline, localBeginEdgeFontStyle.selectedIsStrikeThrough);
            result = LayoutUtil.toEdgeLayout(bendpoints, localEdgeStyle.selectedLineColor, localEdgeStyle.selectedLineWidth, localEdgeStyle.selectedLineStyle, localEdgeStyle.selectedEdgeRouting, localEdgeStyle.selectedTargetArrow, localEdgeStyle.selectedSourceArrow);
            result.setFontStyle(templateFontStyle);
            result.setCenterFontStyle(centerEdgeFontStyle);
            result.setEndFontStyle(endEdgeFontStyle);
            result.setBeginFontStyle(beginEdgeFontStyle);
        }
        return result;
    }

    private void getLocalEdgeStyleData(SiriusDiagramUtil.LocalEdgeStyle localEdgeStyle_p, EdgeStyle edgeStyle_p, EList<String> customFeatures_p) {
        if (customFeatures_p.contains((Object)DiagramPackage.eINSTANCE.getEdgeStyle_StrokeColor().getName())) {
            localEdgeStyle_p.selectedLineColor = ColorUtil.convertRGBValuesToIntColor(edgeStyle_p.getStrokeColor());
        }
        if (customFeatures_p.contains((Object)DiagramPackage.eINSTANCE.getEdgeStyle_Size().getName())) {
            localEdgeStyle_p.selectedLineWidth = edgeStyle_p.getSize();
        }
        if (customFeatures_p.contains((Object)DiagramPackage.eINSTANCE.getEdgeStyle_LineStyle().getName())) {
            localEdgeStyle_p.selectedLineStyle = edgeStyle_p.getLineStyle();
        }
        if (customFeatures_p.contains((Object)DiagramPackage.eINSTANCE.getEdgeStyle_RoutingStyle().getName())) {
            localEdgeStyle_p.selectedEdgeRouting = edgeStyle_p.getRoutingStyle();
        }
        if (customFeatures_p.contains((Object)DiagramPackage.eINSTANCE.getEdgeStyle_TargetArrow().getName())) {
            localEdgeStyle_p.selectedTargetArrow = edgeStyle_p.getTargetArrow();
        }
        if (customFeatures_p.contains((Object)DiagramPackage.eINSTANCE.getEdgeStyle_SourceArrow().getName())) {
            localEdgeStyle_p.selectedSourceArrow = edgeStyle_p.getSourceArrow();
        }
    }

    private void getLocalFontStyleData(SiriusDiagramUtil.LocalFontStyle localfontstyle_p, BasicLabelStyle style_p) {
        EList customFeatures = style_p.getCustomFeatures();
        if (customFeatures.contains(ViewpointPackage.eINSTANCE.getBasicLabelStyle_LabelColor().getName())) {
            localfontstyle_p.selectedFontColor = ColorUtil.convertRGBValuesToIntColor(style_p.getLabelColor());
        }
        if (customFeatures.contains(ViewpointPackage.eINSTANCE.getBasicLabelStyle_LabelFormat().getName())) {
            EList format = style_p.getLabelFormat();
            localfontstyle_p.selectedIsBold = false;
            localfontstyle_p.selectedIsItalic = false;
            localfontstyle_p.selectedIsStrikeThrough = false;
            localfontstyle_p.selectedIsUnderline = false;
            for (FontFormat fontFormat : format) {
                if (FontFormat.BOLD_LITERAL == fontFormat) {
                    localfontstyle_p.selectedIsBold = true;
                    continue;
                }
                if (FontFormat.ITALIC_LITERAL == fontFormat) {
                    localfontstyle_p.selectedIsItalic = true;
                    continue;
                }
                if (fontFormat.equals((Object)FontFormat.STRIKE_THROUGH_LITERAL)) {
                    localfontstyle_p.selectedIsStrikeThrough = true;
                    continue;
                }
                if (!fontFormat.equals((Object)FontFormat.UNDERLINE_LITERAL)) continue;
                localfontstyle_p.selectedIsUnderline = true;
            }
        }
        if (customFeatures.contains(ViewpointPackage.eINSTANCE.getBasicLabelStyle_LabelSize().getName())) {
            localfontstyle_p.selectedFontHeight = style_p.getLabelSize();
        }
    }

    private void getLocalFontStyleDataFromFont(SiriusDiagramUtil.LocalFontStyle localfontstyle_p, FontStyle style_p) {
        localfontstyle_p.selectedFontName = style_p.getFontName();
        localfontstyle_p.selectedFontColor = style_p.getFontColor();
        localfontstyle_p.selectedIsBold = style_p.isBold();
        localfontstyle_p.selectedIsItalic = style_p.isItalic();
        localfontstyle_p.selectedIsStrikeThrough = style_p.isStrikeThrough();
        localfontstyle_p.selectedIsUnderline = style_p.isUnderline();
        localfontstyle_p.selectedFontHeight = style_p.getFontHeight();
    }

    private void getLocalEdgeStyleDataFromConnector(SiriusDiagramUtil.LocalEdgeStyle localEdgeStyle_p, ConnectorStyle connectorStyle_p, List<String> customFeatures_p) {
        if (customFeatures_p.contains(DiagramPackage.eINSTANCE.getEdgeStyle_StrokeColor().getName())) {
            localEdgeStyle_p.selectedLineColor = connectorStyle_p.getLineColor();
        }
        if (customFeatures_p.contains(DiagramPackage.eINSTANCE.getEdgeStyle_Size().getName())) {
            localEdgeStyle_p.selectedLineWidth = connectorStyle_p.getLineWidth();
        }
    }

    private void getViewLayoutData(View view_p, EMap<EObject, Layout> resultMap_p) {
        EObject counterpart;
        EObject semanticElement;
        EObject siriusElement = view_p.getElement();
        if (siriusElement instanceof DSemanticDecorator && (semanticElement = ((DSemanticDecorator)siriusElement).getTarget()) != null && (counterpart = this.getData().getCounterpart(semanticElement, false)) != null && !resultMap_p.containsKey((Object)counterpart)) {
            NodeLayout layout = null;
            if (view_p instanceof Node) {
                Node node = (Node)view_p;
                layout = this.buildLayoutDataForNode(node);
            } else if (view_p instanceof Edge) {
                Edge edge = (Edge)view_p;
                layout = this.buildLayoutDataForEdge(edge);
            }
            if (layout != null) {
                resultMap_p.put((Object)counterpart, (Object)layout);
            }
        }
    }

    private List<View> addIncludedElementsGMFLayout() {
        ArrayList<View> includedElementsViews = new ArrayList<View>();
        DDiagramEditor diagramEditor = this.getDiagramEditor();
        for (EObject obj : this.getData().getAllElements()) {
            LayerNavigator navigator = new LayerNavigator(obj, diagramEditor);
            View gmfElement = navigator.getUpGmfElement(navigator.getUpSiriusElement(obj));
            if (gmfElement == null || includedElementsViews.contains(gmfElement)) continue;
            includedElementsViews.add(gmfElement);
        }
        return includedElementsViews;
    }

    private DDiagramEditor getDiagramEditor() {
        IEditorPart editor;
        IWorkbenchPage page;
        DDiagramEditor diagramEditor = null;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null && (editor = page.getActiveEditor()) instanceof DDiagramEditor) {
            diagramEditor = (DDiagramEditor)editor;
        }
        return diagramEditor;
    }

    private NodeLayout buildLayoutDataForNode(Node node_p) {
        NodeLayout result = null;
        LayoutConstraint constraint = node_p.getLayoutConstraint();
        if (constraint instanceof Bounds) {
            Bounds bounds = (Bounds)constraint;
            List<String> nodeCustomFeatures = LayoutUtil.getNodeCustomSpecification(node_p);
            SiriusDiagramUtil.LocalNodeStyle localNodeStyle = new SiriusDiagramUtil.LocalNodeStyle();
            SiriusDiagramUtil.LocalFontStyle localFontStyle = new SiriusDiagramUtil.LocalFontStyle();
            EList styles = node_p.getStyles();
            for (org.eclipse.gmf.runtime.notation.Style style : styles) {
                if (style instanceof ShapeStyle) {
                    ShapeStyle shapestyle = (ShapeStyle)style;
                    this.getLocalNodeStyle(localNodeStyle, shapestyle, node_p.getElement(), nodeCustomFeatures);
                    this.getLocalFontStyleData(localFontStyle, (FontStyle)shapestyle, nodeCustomFeatures);
                    continue;
                }
                if (!(style instanceof FontStyle)) continue;
                FontStyle fontstyle = (FontStyle)style;
                this.getLocalFontStyleDataFromFontStyle(localFontStyle, fontstyle);
            }
            NodeStyle templateNodeStyle = LayoutUtil.toTemplateNodeStyle(localNodeStyle.selectedNSBorderColor, localNodeStyle.selectedNSBorderSize, localNodeStyle.selectedNSShapeColor, localNodeStyle.selectedNSTransparency, localNodeStyle.selectedNSForegroundColor, localNodeStyle.selectedNSBackgroundColor);
            TemplateFontStyle templateFontStyle = LayoutUtil.toTemplateFontStyle(localFontStyle.selectedFontColor, localFontStyle.selectedFontName, localFontStyle.selectedFontHeight, localFontStyle.selectedIsBold, localFontStyle.selectedIsItalic, localFontStyle.selectedIsUnderline, localFontStyle.selectedIsStrikeThrough);
            result = LayoutUtil.toNodeLayout(bounds, templateNodeStyle, templateFontStyle);
        }
        return result;
    }

    private void getLocalFontStyleDataFromFontStyle(SiriusDiagramUtil.LocalFontStyle localFontStyle_p, FontStyle fontStyle_p) {
        localFontStyle_p.selectedFontColor = fontStyle_p.getFontColor();
        localFontStyle_p.selectedFontHeight = fontStyle_p.getFontHeight();
        localFontStyle_p.selectedFontName = fontStyle_p.getFontName();
    }

    private void getLocalNodeStyle(SiriusDiagramUtil.LocalNodeStyle localNodeStyle_p, ShapeStyle shapeStyle_p, EObject nodeElement_p, List<String> customFeatures_p) {
        DDiagramElement diagelement;
        Style elementstyle;
        localNodeStyle_p.selectedNSTransparency = shapeStyle_p.getTransparency();
        if (customFeatures_p.contains("color")) {
            localNodeStyle_p.selectedNSShapeColor = shapeStyle_p.getFillColor();
        }
        if (customFeatures_p.contains(DiagramPackage.eINSTANCE.getFlatContainerStyle_ForegroundColor().getName()) && customFeatures_p.contains(DiagramPackage.eINSTANCE.getFlatContainerStyle_BackgroundColor().getName())) {
            localNodeStyle_p.selectedNSShapeColor = shapeStyle_p.getFillColor();
        }
        if (customFeatures_p.contains(DiagramPackage.eINSTANCE.getBorderedStyle_BorderColor().getName())) {
            localNodeStyle_p.selectedNSBorderColor = shapeStyle_p.getLineColor();
        }
        if (customFeatures_p.contains(DiagramPackage.eINSTANCE.getBorderedStyle_BorderSize().getName())) {
            localNodeStyle_p.selectedNSBorderSize = shapeStyle_p.getLineWidth();
        }
        if (nodeElement_p instanceof DDiagramElementContainer) {
            DDiagramElementContainer container = (DDiagramElementContainer)nodeElement_p;
            ContainerStyle containerstyle = container.getOwnedStyle();
            if (customFeatures_p.contains(DiagramPackage.eINSTANCE.getBorderedStyle_BorderSizeComputationExpression().getName())) {
                localNodeStyle_p.selectedNSBorderSize = containerstyle.getBorderSize();
            }
            if (containerstyle instanceof FlatContainerStyle) {
                FlatContainerStyle flatcontainerstyle = (FlatContainerStyle)containerstyle;
                if (customFeatures_p.contains(DiagramPackage.eINSTANCE.getFlatContainerStyle_ForegroundColor().getName())) {
                    localNodeStyle_p.selectedNSForegroundColor = ColorUtil.convertRGBValuesToIntColor(flatcontainerstyle.getForegroundColor());
                }
                if (customFeatures_p.contains(DiagramPackage.eINSTANCE.getFlatContainerStyle_BackgroundColor().getName())) {
                    localNodeStyle_p.selectedNSBackgroundColor = ColorUtil.convertRGBValuesToIntColor(flatcontainerstyle.getBackgroundColor());
                }
            }
        } else if (nodeElement_p instanceof DDiagramElement && (elementstyle = (diagelement = (DDiagramElement)nodeElement_p).getStyle()) instanceof Square) {
            Square squareelementstyle = (Square)elementstyle;
            if (customFeatures_p.contains(DiagramPackage.eINSTANCE.getBorderedStyle_BorderSizeComputationExpression().getName())) {
                localNodeStyle_p.selectedNSBorderSize = squareelementstyle.getBorderSize();
            }
            if (customFeatures_p.contains(DiagramPackage.eINSTANCE.getFlatContainerStyle_ForegroundColor().getName())) {
                localNodeStyle_p.selectedNSForegroundColor = ColorUtil.convertRGBValuesToIntColor(squareelementstyle.getColor());
            }
            if (customFeatures_p.contains(DiagramPackage.eINSTANCE.getFlatContainerStyle_BackgroundColor().getName())) {
                localNodeStyle_p.selectedNSBackgroundColor = ColorUtil.convertRGBValuesToIntColor(squareelementstyle.getColor());
            }
        }
    }

    private void getLocalFontStyleData(SiriusDiagramUtil.LocalFontStyle localfontstyle_p, FontStyle fontstyle_p, List<String> customFeatures_p) {
        localfontstyle_p.selectedFontName = fontstyle_p.getFontName();
        localfontstyle_p.selectedIsStrikeThrough = fontstyle_p.isStrikeThrough();
        localfontstyle_p.selectedIsUnderline = fontstyle_p.isUnderline();
        if (customFeatures_p.contains(ViewpointPackage.eINSTANCE.getBasicLabelStyle_LabelColor().getName())) {
            localfontstyle_p.selectedFontColor = fontstyle_p.getFontColor();
        }
        if (customFeatures_p.contains(ViewpointPackage.eINSTANCE.getBasicLabelStyle_LabelFormat().getName())) {
            localfontstyle_p.selectedIsBold = fontstyle_p.isBold();
            localfontstyle_p.selectedIsItalic = fontstyle_p.isItalic();
        }
        if (customFeatures_p.contains(ViewpointPackage.eINSTANCE.getBasicLabelStyle_LabelSize().getName())) {
            localfontstyle_p.selectedFontHeight = fontstyle_p.getFontHeight();
        }
    }
}

