/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.ui.viewers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.diffmerge.generic.api.IMatch;
import org.eclipse.emf.diffmerge.generic.api.Role;
import org.eclipse.emf.diffmerge.generic.gdiffdata.GComparison;
import org.eclipse.emf.diffmerge.ui.util.DiffDecoratingLabelProvider;
import org.eclipse.emf.diffmerge.ui.util.UIUtil;
import org.eclipse.emf.diffmerge.ui.viewers.CategoryManager;
import org.eclipse.emf.diffmerge.ui.viewers.EMFDiffNode;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreePathContentProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;

public class ComparisonTreeViewer
extends TreeViewer {
    public ComparisonTreeViewer(Composite parent_p) {
        this(parent_p, 770);
    }

    public ComparisonTreeViewer(Composite parent_p, int style_p) {
        super(parent_p, style_p);
        this.setContentProvider((IContentProvider)new ContentProvider());
        this.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this);
        this.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
    }

    public ITreePathContentProvider getContentProvider() {
        return (ITreePathContentProvider)super.getContentProvider();
    }

    protected Role getDrivingRole() {
        return this.getInput().getDrivingRole();
    }

    public EMFDiffNode getInput() {
        return (EMFDiffNode)super.getInput();
    }

    protected TreePath getFirstIn(TreePath path_p) {
        TreePath result = null;
        Object[] children = this.getSortedChildren(path_p);
        if (children.length > 0) {
            result = path_p.createChildPath(children[0]);
        }
        return result;
    }

    protected TreePath getLastIn(TreePath path_p) {
        TreePath result = null;
        Object[] children = this.getSortedChildren(path_p);
        if (children.length > 0) {
            result = path_p;
            while (children.length > 0) {
                Object last = children[children.length - 1];
                result = result.createChildPath(last);
                children = this.getSortedChildren(result);
            }
        }
        return result;
    }

    protected TreePath getNextOf(TreePath path_p) {
        TreePath result = this.getFirstIn(path_p);
        if (result == null && path_p.getSegmentCount() > 0 && (result = this.getNextSiblingOf(path_p)) == null) {
            TreePath parentPath = path_p.getParentPath();
            while (result == null && parentPath.getSegmentCount() > 0) {
                result = this.getNextSiblingOf(parentPath);
                parentPath = parentPath.getParentPath();
            }
        }
        return result;
    }

    protected TreePath getNextSiblingOf(TreePath path_p) {
        TreePath parentPath;
        Object[] siblingsArray;
        List<Object> siblings;
        int nextPos;
        TreePath result = null;
        Object end = path_p.getLastSegment();
        if (end != null && (nextPos = (siblings = Arrays.asList(siblingsArray = this.getSortedChildren(parentPath = path_p.getParentPath()))).indexOf(end) + 1) < siblings.size()) {
            result = parentPath.createChildPath(siblings.get(nextPos));
        }
        return result;
    }

    public TreePath getNextUserDifference(TreePath path_p) {
        TreePath result = null;
        TreePath next = this.getNextOf(path_p);
        while (result == null && next != null) {
            if (this.getInput().getCategoryManager().representAsUserDifference(next)) {
                result = next;
                continue;
            }
            next = this.getNextOf(next);
        }
        return result;
    }

    protected List<List<IMatch<?>>> getPathsFor(IMatch<?> match_p, boolean parentsOnly_p, boolean coverOppositeSide_p) {
        List<List<Object>> result;
        GComparison comparison;
        EMFDiffNode input = this.getInput();
        GComparison gComparison = comparison = input != null ? input.getActualComparison() : null;
        if (match_p == null || comparison == null) {
            result = new ArrayList();
        } else {
            boolean isRoot;
            Role drivingRole = this.getDrivingRole();
            boolean bl = isRoot = comparison.getContents(drivingRole).contains(match_p) || match_p.getUncoveredRole() == drivingRole && comparison.getContents(drivingRole.opposite()).contains(match_p);
            if (isRoot) {
                result = new ArrayList();
                result.add(new ArrayList());
            } else {
                IMatch oppositeContainer;
                boolean coverContainerOppositeSide = false;
                IMatch drivingContainer = comparison.getContainerOf(match_p, drivingRole);
                result = this.getPathsFor(drivingContainer, false, false);
                if (coverOppositeSide_p && (oppositeContainer = comparison.getContainerOf(match_p, drivingRole.opposite())) != null && oppositeContainer != drivingContainer) {
                    List<List<IMatch<?>>> oppositePaths = this.getPathsFor(oppositeContainer, false, false);
                    CategoryManager categoryManager = this.getInput().getCategoryManager();
                    for (List<IMatch<?>> oppositePath : oppositePaths) {
                        if (categoryManager.representAsMoveOrigin(UIUtil.toTreePath(oppositePath))) continue;
                        result.add(oppositePath);
                    }
                }
            }
            if (!parentsOnly_p) {
                for (List<Object> path : result) {
                    path.add(match_p);
                }
            }
        }
        return result;
    }

    protected TreePath getPreviousOf(TreePath path_p) {
        TreePath result = null;
        if (path_p.getSegmentCount() == 0) {
            result = this.getLastIn(path_p);
        } else {
            TreePath siblingPath = this.getPreviousSiblingOf(path_p);
            if (siblingPath != null) {
                result = this.getLastIn(siblingPath);
                if (result == null) {
                    result = siblingPath;
                }
            } else {
                TreePath parentPath = path_p.getParentPath();
                if (parentPath.getSegmentCount() > 0) {
                    result = parentPath;
                }
            }
        }
        return result;
    }

    protected TreePath getPreviousSiblingOf(TreePath path_p) {
        TreePath parentPath;
        Object[] siblingsArray;
        List<Object> siblings;
        int prevPos;
        TreePath result = null;
        Object end = path_p.getLastSegment();
        if (end != null && (prevPos = (siblings = Arrays.asList(siblingsArray = this.getSortedChildren(parentPath = path_p.getParentPath()))).indexOf(end) - 1) >= 0) {
            result = parentPath.createChildPath(siblings.get(prevPos));
        }
        return result;
    }

    public TreePath getPreviousUserDifference(TreePath path_p) {
        TreePath result = null;
        TreePath previous = this.getPreviousOf(path_p);
        while (result == null && previous != null) {
            if (this.getInput().getCategoryManager().representAsUserDifference(previous)) {
                result = previous;
                continue;
            }
            previous = this.getPreviousOf(previous);
        }
        return result;
    }

    protected Object[] getRawChildren(Object parent_p) {
        Object[] result = parent_p instanceof TreePath && ((TreePath)parent_p).getSegmentCount() == 0 ? this.getContentProvider().getElements((Object)this.getInput()) : super.getRawChildren(parent_p);
        return result;
    }

    public ITreeSelection getSelection() {
        return (ITreeSelection)super.getSelection();
    }

    public Object[] getSortedChildren(Object parentElementOrTreePath_p) {
        return super.getSortedChildren(parentElementOrTreePath_p);
    }

    public void setDirected(boolean value) {
        ((LabelProvider)this.getLabelProvider()).setDirected(value);
    }

    protected class ContentProvider
    implements ITreePathContentProvider {
        protected ContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getChildren(TreePath parentPath_p) {
            IMatch end = (IMatch)parentPath_p.getLastSegment();
            List result = end == null ? ComparisonTreeViewer.this.getInput().getActualComparison().getContents() : (ComparisonTreeViewer.this.getInput().getCategoryManager().representAsMoveOrigin(parentPath_p) ? Collections.emptyList() : ComparisonTreeViewer.this.getInput().getActualComparison().getContentsOf(end));
            return result.toArray();
        }

        public Object[] getElements(Object inputElement_p) {
            List result = Collections.emptyList();
            EMFDiffNode input = (EMFDiffNode)inputElement_p;
            if (input != null) {
                result = input.getActualComparison().getContents();
            }
            return result.toArray();
        }

        public TreePath[] getParents(Object element_p) {
            List<List<IMatch<?>>> resultAsList = ComparisonTreeViewer.this.getPathsFor((IMatch)element_p, true, true);
            return UIUtil.toTreePaths(resultAsList);
        }

        public boolean hasChildren(TreePath path_p) {
            return ComparisonTreeViewer.this.getSortedChildren(path_p).length > 0;
        }

        public void inputChanged(Viewer viewer_p, Object oldInput_p, Object newInput_p) {
        }
    }

    protected class LabelProvider
    extends DiffDecoratingLabelProvider {
        protected LabelProvider() {
        }

        @Override
        protected EMFDiffNode getDiffNode() {
            return ComparisonTreeViewer.this.getInput();
        }

        @Override
        protected Role getSide() {
            return null;
        }

        @Override
        public String getToolTipText(Object element_p) {
            return this.getMatchIDText(element_p);
        }
    }
}

