/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.patterns.diagrams.sirius.util;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.diffmerge.patterns.diagrams.PatternCoreDiagramPlugin;
import org.eclipse.emf.diffmerge.patterns.diagrams.extensions.ISemanticMapping;
import org.eclipse.emf.diffmerge.patterns.diagrams.sirius.extensions.ISiriusSemanticMapping;
import org.eclipse.emf.diffmerge.patterns.diagrams.sirius.util.SiriusLayersUtil;
import org.eclipse.emf.diffmerge.patterns.diagrams.sirius.util.SiriusUtil;
import org.eclipse.emf.diffmerge.patterns.diagrams.util.AbstractDiagramUtil;
import org.eclipse.emf.diffmerge.util.structures.FOrderedSet;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.render.clipboard.DiagramSVGGenerator;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.EdgeArrows;
import org.eclipse.sirius.diagram.EdgeRouting;
import org.eclipse.sirius.diagram.LineStyle;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.Layer;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SiriusDiagramUtil
extends AbstractDiagramUtil {
    public List<?> getDiagramElements(Object diagram_p) {
        if (diagram_p instanceof DDiagram) {
            return ((DDiagram)diagram_p).getDiagramElements();
        }
        return Collections.emptyList();
    }

    public List<EObject> getSemanticElementsFor(Object diagramElement_p) {
        if (diagramElement_p instanceof DDiagramElement) {
            return ((DDiagramElement)diagramElement_p).getSemanticElements();
        }
        return Collections.emptyList();
    }

    public Point getLocation(Object diagramElement_p) {
        Node node;
        LayoutConstraint constraint;
        List<View> views;
        Point vector = new Point(0, 0);
        if (diagramElement_p instanceof DDiagramElement && !(views = SiriusLayersUtil.upViewpointToGmf((DSemanticDecorator)((DDiagramElement)diagramElement_p))).isEmpty() && views.get(0) instanceof Node && (constraint = (node = (Node)views.get(0)).getLayoutConstraint()) instanceof Bounds) {
            Bounds bounds = (Bounds)constraint;
            vector.x = bounds.getX();
            vector.y = bounds.getY();
        }
        return vector;
    }

    public EObject getTechnicalContainerFor(Object diagramElement_p) {
        if (diagramElement_p instanceof DDiagramElement) {
            return ((DDiagramElement)diagramElement_p).eContainer();
        }
        return null;
    }

    public Collection<?> toActualSelection(Object selected_p) {
        FOrderedSet result = new FOrderedSet();
        EObject viewpointElement = SiriusLayersUtil.getViewpointElement(selected_p);
        if (viewpointElement instanceof DSemanticDecorator) {
            ISemanticMapping mapping = PatternCoreDiagramPlugin.getDefault().getSemanticMapping();
            if (mapping instanceof ISiriusSemanticMapping) {
                result.addAll(((ISiriusSemanticMapping)mapping).getSemanticSelection(viewpointElement));
            }
        } else if (viewpointElement != null) {
            result.add(viewpointElement);
        }
        return result;
    }

    public DDiagram getDiagramFromSelection(IStructuredSelection selection_p) {
        if (selection_p != null) {
            for (Object current : selection_p) {
                EObject viewpointElement = SiriusLayersUtil.getViewpointElement(current);
                DDiagram diagram = SiriusUtil.getDiagram(viewpointElement);
                if (diagram == null) continue;
                return diagram;
            }
        }
        return null;
    }

    public String exportToSVG(final List<Object> gefElements_p) {
        Object obj;
        String result = null;
        if (!gefElements_p.isEmpty() && (obj = gefElements_p.get(0)) instanceof IGraphicalEditPart) {
            DiagramEditPart diagramEditPart = SiriusDiagramUtil.getDiagramEditPart((IGraphicalEditPart)obj);
            final DiagramSVGGenerator gen = new DiagramSVGGenerator(diagramEditPart);
            if (gefElements_p.contains(diagramEditPart)) {
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        gen.createSWTImageDescriptorForDiagram();
                    }
                });
            } else {
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        gen.createSWTImageDescriptorForParts(gefElements_p);
                    }
                });
            }
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            try {
                gen.stream((OutputStream)outStream);
                outStream.close();
                result = outStream.toString("UTF-8");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public static DiagramEditPart getDiagramEditPart(IGraphicalEditPart editPart_p) {
        EditPart rootContents;
        DiagramEditPart result = null;
        RootEditPart root = editPart_p.getRoot();
        if (root != null && (rootContents = root.getContents()) instanceof DiagramEditPart) {
            result = (DiagramEditPart)rootContents;
        }
        return result;
    }

    public EObject getSemanticRepresentationTypeTarget(Object semanticDecorator_p) {
        if (semanticDecorator_p instanceof DSemanticDecorator) {
            return ((DSemanticDecorator)semanticDecorator_p).getTarget();
        }
        return null;
    }

    public Collection<?> getOwnedDiagramElements(Object semanticDecorator_p) {
        if (semanticDecorator_p instanceof DNodeContainer) {
            return ((DNodeContainer)semanticDecorator_p).getOwnedDiagramElements();
        }
        return Collections.emptyList();
    }

    public boolean isShowInstanceEnabled(Object diagram_p) {
        DDiagram diagram;
        DiagramDescription description;
        boolean result;
        boolean bl = result = diagram_p != null;
        if (diagram_p instanceof DDiagram && result && (description = (diagram = (DDiagram)diagram_p).getDescription()) != null) {
            FOrderedSet allMappings = new FOrderedSet();
            for (Layer activeLayer : diagram.getActivatedLayers()) {
                allMappings.addAll(activeLayer.getContainerMappings());
                allMappings.addAll(activeLayer.getNodeMappings());
                allMappings.addAll(activeLayer.getEdgeMappings());
            }
            Iterator it = allMappings.iterator();
            result = false;
            while (!result && it.hasNext()) {
                DiagramElementMapping current = (DiagramElementMapping)it.next();
                boolean bl2 = result = !current.isSynchronizationLock();
            }
        }
        return result;
    }

    public static class LocalEdgeStyle {
        public int selectedLineColor = -1;
        public int selectedLineWidth = -1;
        public LineStyle selectedLineStyle = null;
        public EdgeRouting selectedEdgeRouting = null;
        public EdgeArrows selectedTargetArrow = null;
        public EdgeArrows selectedSourceArrow = null;
    }

    public static class LocalFontStyle {
        public int selectedFontColor = -1;
        public String selectedFontName = "default";
        public int selectedFontHeight = -1;
        public boolean selectedIsBold = false;
        public boolean selectedIsItalic = false;
        public boolean selectedIsStrikeThrough = false;
        public boolean selectedIsUnderline = false;
    }

    public static class LocalNodeStyle {
        public int selectedNSBorderColor = -1;
        public int selectedNSBorderSize = -1;
        public int selectedNSShapeColor = -1;
        public int selectedNSTransparency = -1;
        public int selectedNSForegroundColor = -1;
        public int selectedNSBackgroundColor = -1;
    }
}

