/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.patterns.templates.engine.diffmerge;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.diffmerge.impl.scopes.FilteredModelScope;
import org.eclipse.emf.diffmerge.patterns.core.api.IPatternApplication;
import org.eclipse.emf.diffmerge.patterns.core.api.IPatternInstanceMarker;
import org.eclipse.emf.diffmerge.patterns.templates.engine.TemplatePatternsUtil;
import org.eclipse.emf.diffmerge.patterns.templates.gen.templatepatterns.TemplatePatternData;
import org.eclipse.emf.diffmerge.util.ModelsUtil;
import org.eclipse.emf.diffmerge.util.structures.FHashSet;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplatePatternApplicationScope
extends FilteredModelScope {
    private final IPatternApplication _application;
    private final Collection<EObject> _deletedElements;
    private String _multipart;
    private final ModelsUtil.IElementFilter _filter;

    public TemplatePatternApplicationScope(IPatternApplication application_p, String multipart_p) {
        super(TemplatePatternsUtil.getApplicationRoots(application_p));
        this._application = application_p;
        this._filter = new TemplatePatternApplicationFilter();
        this._deletedElements = new FHashSet();
        this.setMultipart(multipart_p);
    }

    public void build(ModelsUtil.IElementFilter filter_p) {
        super.build(filter_p);
        TemplatePatternsUtil.adjust(this);
    }

    public IPatternApplication getApplication() {
        return this._application;
    }

    public Collection<EObject> getDeletedElements() {
        return Collections.unmodifiableCollection(this._deletedElements);
    }

    public String getMultipart() {
        return this._multipart;
    }

    public boolean remove(EObject element_p) {
        boolean result = this._roots.remove(element_p);
        this.removeFromScope(element_p, true);
        this._deletedElements.add(element_p);
        return result;
    }

    public boolean remove(EObject source_p, EReference reference_p, EObject value_p) {
        boolean result = reference_p.isContainment() ? this._deletedElements.add(value_p) : super.remove(source_p, reference_p, value_p);
        return result;
    }

    public void setMultipart(String multipart_p) {
        this._multipart = multipart_p;
        this.build(this._filter);
    }

    public static class PatternInstanceMarkerFilter
    implements ModelsUtil.IElementFilter {
        public boolean accepts(EObject element_p) {
            return !(element_p instanceof IPatternInstanceMarker);
        }
    }

    private class TemplatePatternApplicationFilter
    extends PatternInstanceMarkerFilter {
        private final TemplatePatternData _data;

        public TemplatePatternApplicationFilter() {
            this._data = TemplatePatternsUtil.getPatternData(TemplatePatternApplicationScope.this.getApplication());
        }

        public boolean accepts(EObject element_p) {
            boolean result = super.accepts(element_p);
            String multipart = TemplatePatternApplicationScope.this.getMultipart();
            if (result && this._data != null && multipart != null) {
                result = this._data.getMultipartOf(element_p) == null || !this._data.isInOtherMultipart(element_p, multipart);
            }
            return result;
        }
    }
}

