/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.db.viewer.views;

import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.StringTokenizer;
import org.eclipse.dirigible.ide.common.CommonParameters;
import org.eclipse.dirigible.ide.db.viewer.views.DatabaseViewer;
import org.eclipse.dirigible.ide.db.viewer.views.ISQLConsole;
import org.eclipse.dirigible.ide.db.viewer.views.Messages;
import org.eclipse.dirigible.ide.editor.text.editor.AbstractTextEditorWidget;
import org.eclipse.dirigible.ide.editor.text.editor.EditorMode;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.part.ViewPart;

public abstract class AbstractSQLConsole
extends ViewPart
implements ISQLConsole {
    private static final String EXECUTE_QUERY_STATEMENT = Messages.SQLConsole_EXECUTE_QUERY_STATEMENT;
    private static final String EXECUTE_QUERY = Messages.SQLConsole_EXECUTE_QUERY;
    private static final String EXECUTE_UPDATE_STATEMENT = Messages.SQLConsole_EXECUTE_UPDATE_STATEMENT;
    private static final String EXECUTE_UPDATE_TEXT = Messages.SQLConsole_EXECUTE_UPDATE_TEXT;
    private static final char SPACE = ' ';
    private static final char MINUS = '-';
    private static final String EMPTY = "";
    private static final String DOTS = "...\n";
    private static final String NULL = "NULL";
    private static final String ICON_EXECUTE_UPDATE_PNG = "icon-execute.png";
    private static final String ICON_EXECUTE_QUERY_PNG = "icon-execute.png";
    private static final String ICONS_SEGMENT = "/icons/";
    private static final String POPUP_MENU = "#PopupMenu";
    private static final String UPDATE_COUNT_S = Messages.SQLConsole_UPDATE_COUNT_S;
    private static final String EXECUTE_UPDATE = Messages.SQLConsole_EXECUTE_UPDATE;
    private static final String BINARY = "[BINARY]";
    private static final Logger logger = Logger.getLogger(AbstractSQLConsole.class);
    private static final String COLUMN_DELIMITER = "|";
    private static final String END_DELIMITER = "|\n";
    public static final String ID = "org.eclipse.dirigible.ide.db.viewer.views.SQLConsole";
    private AbstractTextEditorWidget scriptArea = null;
    private Text outputArea = null;
    private Action actionExecuteUpdate;
    private Action actionExecuteQuery;
    public static final String SCRIPT_DELIMITER = ";";

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        ToolBar toolBar = new ToolBar(parent, 8521800);
        SashForm sashForm = new SashForm(parent, 2560);
        sashForm.setLayoutData((Object)new GridData(4, 4, true, true));
        this.scriptArea = this.createSQLEditorWidget(sashForm);
        this.scriptArea.setLayoutData((Object)new GridData(4, 4, true, true));
        this.scriptArea.setText(EMPTY, this.getMode(), false, false, 0);
        this.outputArea = new Text((Composite)sashForm, 778);
        this.outputArea.setLayoutData((Object)new GridData(4, 4, true, true));
        this.outputArea.setText(EMPTY);
        this.outputArea.setFont(new Font(null, "Courier New", 12, 0));
        ToolItem itemQuery = new ToolItem(toolBar, 10);
        itemQuery.setText(EXECUTE_QUERY);
        Image iconQuery = ImageDescriptor.createFromURL((URL)AbstractSQLConsole.class.getResource("/icons/icon-execute.png")).createImage();
        itemQuery.setImage(iconQuery);
        itemQuery.addSelectionListener(new SelectionListener(){
            private static final long serialVersionUID = 1281159157504712273L;

            public void widgetSelected(SelectionEvent e) {
                AbstractSQLConsole.this.actionExecuteQuery.run();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        boolean isOperator = CommonParameters.isUserInRole((String)"Operator");
        if (isOperator) {
            new ToolItem(toolBar, 2);
            ToolItem itemUpdate = new ToolItem(toolBar, 8);
            itemUpdate.setText(EXECUTE_UPDATE);
            Image iconUpdate = ImageDescriptor.createFromURL((URL)AbstractSQLConsole.class.getResource("/icons/icon-execute.png")).createImage();
            itemUpdate.setImage(iconUpdate);
            itemUpdate.addSelectionListener(new SelectionListener(){
                private static final long serialVersionUID = 1281159157504712273L;

                public void widgetSelected(SelectionEvent e) {
                    AbstractSQLConsole.this.actionExecuteUpdate.run();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
        this.makeActions();
        this.hookContextMenu();
    }

    protected abstract AbstractTextEditorWidget createSQLEditorWidget(SashForm var1);

    public void setFocus() {
        this.scriptArea.setFocus();
    }

    private void makeActions() {
        this.actionExecuteQuery = new Action(){
            private static final long serialVersionUID = -4666336820729503841L;

            public void run() {
                AbstractSQLConsole.this.executeStatement(true);
            }
        };
        this.actionExecuteQuery.setText(EXECUTE_QUERY);
        this.actionExecuteQuery.setToolTipText(EXECUTE_QUERY_STATEMENT);
        this.actionExecuteUpdate = new Action(){
            private static final long serialVersionUID = -4666336820729503841L;

            public void run() {
                AbstractSQLConsole.this.executeStatement(false);
            }
        };
        this.actionExecuteUpdate.setText(EXECUTE_UPDATE_TEXT);
        this.actionExecuteUpdate.setToolTipText(EXECUTE_UPDATE_STATEMENT);
    }

    @Override
    public void executeStatement(boolean isQuery) {
        String sql = this.scriptArea.getText();
        if (sql == null || sql.length() == 0) {
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(sql, SCRIPT_DELIMITER);
        while (tokenizer.hasMoreTokens()) {
            String line = tokenizer.nextToken();
            if (EMPTY.equals(line.trim())) continue;
            this.executeSingleStatement(line, isQuery);
        }
    }

    private void executeSingleStatement(String sql, boolean isQuery) {
        try {
            Connection connection = this.getConnection();
            try {
                PreparedStatement preparedStatement = connection.prepareStatement(sql);
                if (isQuery) {
                    preparedStatement.executeQuery();
                    ResultSet resultSet = preparedStatement.getResultSet();
                    this.printResultSet(resultSet);
                } else {
                    preparedStatement.executeUpdate();
                    this.printUpdateCount(preparedStatement.getUpdateCount());
                }
            }
            finally {
                if (connection != null) {
                    connection.close();
                }
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            this.outputArea.setText(e.getMessage());
        }
    }

    public Connection getConnection() throws Exception {
        return DatabaseViewer.getConnectionFromSelectedDatasource();
    }

    private void printResultSet(ResultSet resultSet) throws SQLException {
        int columnType;
        StringBuffer buff = new StringBuffer();
        int headerLength = 0;
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int i = 1;
        while (i <= resultSetMetaData.getColumnCount()) {
            String columnLabel = resultSetMetaData.getColumnLabel(i);
            String columnLabelPrint = null;
            columnType = resultSetMetaData.getColumnType(i);
            columnLabelPrint = this.isBinaryType(columnType) ? this.prepareStringForSize(columnLabel, BINARY.length(), ' ') : this.prepareStringForSize(columnLabel, resultSetMetaData.getColumnDisplaySize(i), ' ');
            buff.append(columnLabelPrint);
            headerLength += columnLabelPrint.length();
            ++i;
        }
        buff.append(END_DELIMITER);
        buff.append(this.prepareStringForSize(EMPTY, headerLength - 1, '-'));
        buff.append(END_DELIMITER);
        int count = 0;
        while (resultSet.next()) {
            int i2 = 1;
            while (i2 <= resultSetMetaData.getColumnCount()) {
                String data = null;
                columnType = resultSetMetaData.getColumnType(i2);
                data = this.isBinaryType(columnType) ? BINARY : resultSet.getString(i2);
                String dataPrint = null;
                dataPrint = this.isBinaryType(columnType) ? this.prepareStringForSize(data, BINARY.length(), ' ') : this.prepareStringForSize(data, resultSetMetaData.getColumnDisplaySize(i2), ' ');
                buff.append(dataPrint);
                ++i2;
            }
            buff.append(END_DELIMITER);
            if (++count <= 100) continue;
            buff.append(DOTS);
            break;
        }
        this.outputArea.setText(buff.toString());
    }

    private boolean isBinaryType(int columnType) {
        int[] nArray = CommonParameters.BINARY_TYPES;
        int n = CommonParameters.BINARY_TYPES.length;
        int n2 = 0;
        while (n2 < n) {
            int c = nArray[n2];
            if (columnType == c) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private String prepareStringForSize(String columnLabel, int columnDisplaySize, char c) {
        String result;
        if (columnLabel == null) {
            columnLabel = NULL;
        }
        if (columnLabel.length() == columnDisplaySize) {
            result = columnLabel;
        } else if (columnLabel.length() > columnDisplaySize) {
            result = columnLabel.substring(0, columnDisplaySize);
        } else {
            StringBuffer buff = new StringBuffer();
            buff.append(columnLabel);
            int i = 0;
            while (i < columnDisplaySize - columnLabel.length()) {
                buff.append(c);
                ++i;
            }
            result = buff.toString();
        }
        return COLUMN_DELIMITER + result;
    }

    private void printUpdateCount(int updateCount) {
        this.outputArea.setText(String.format(UPDATE_COUNT_S, updateCount));
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager(POPUP_MENU);
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){
            private static final long serialVersionUID = 7417283863427269417L;

            public void menuAboutToShow(IMenuManager manager) {
                AbstractSQLConsole.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)this.scriptArea);
        this.scriptArea.setMenu(menu);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionExecuteUpdate);
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new Separator("additions"));
    }

    @Override
    public void setQuery(String query) {
        this.scriptArea.setText(query, this.getMode(), false, false, 0);
    }

    private EditorMode getMode() {
        return EditorMode.SQL;
    }
}

