/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.template.ui.is.wizard;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Path;
import org.eclipse.dirigible.ide.template.ui.common.GenerationModel;
import org.eclipse.dirigible.ide.template.ui.common.TemplateGenerator;
import org.eclipse.dirigible.ide.template.ui.is.wizard.IntegrationServiceTemplateModel;

public class IntegrationServiceTemplateGenerator
extends TemplateGenerator {
    private static final String LOG_TAG = "INTEGRATION_SERVICE_GENERATOR";
    private IntegrationServiceTemplateModel model;

    public IntegrationServiceTemplateGenerator(IntegrationServiceTemplateModel model) {
        this.model = model;
    }

    protected Map<String, Object> prepareParameters() {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("id", this.model.getId());
        parameters.put("endpointAddress", this.model.getEndpointAddress());
        parameters.put("projectName", this.model.getProjectName());
        String fileNameNoExtension = this.model.getFileNameNoExtension();
        parameters.put("fileNameNoExtension", fileNameNoExtension);
        String fileNameNoExtensionTitle = fileNameNoExtension;
        if (fileNameNoExtension != null && fileNameNoExtension.length() > 1) {
            char[] chars = fileNameNoExtension.toCharArray();
            chars[0] = Character.toUpperCase(chars[0]);
            fileNameNoExtensionTitle = new String(chars);
        }
        parameters.put("fileNameNoExtensionTitle", fileNameNoExtensionTitle);
        return parameters;
    }

    protected GenerationModel getModel() {
        return this.model;
    }

    protected String getLogTag() {
        return LOG_TAG;
    }

    protected byte[] afterGeneration(byte[] bytes) {
        String content = new String(bytes);
        content = content.replace("\\$", "$");
        content = content.replace("\\{", "{");
        content = content.replace("\\}", "}");
        content = content.replace("\\.", ".");
        byte[] result = content.getBytes();
        return result;
    }

    public void generate() throws Exception {
        super.generate();
        Path targetLocationPath = new Path(this.getModel().getTargetLocation());
        String projectName = this.getModel().getProjectName();
        targetLocationPath = targetLocationPath.removeLastSegments(targetLocationPath.segmentCount() - 1);
        String targetLocationPathJavaScriptServices = targetLocationPath.append("/").append("ScriptingServices").append("/").append(projectName).toString();
        if ("/org/eclipse/dirigible/ide/template/ui/is/templates/shielding-js.flow".equals(this.model.getTemplate().getLocation())) {
            this.generateFile("/org/eclipse/dirigible/ide/template/ui/is/templates/javascript-sync.js", targetLocationPathJavaScriptServices, String.valueOf(this.model.getEndpointAddress()) + ".js");
        }
        if ("/org/eclipse/dirigible/ide/template/ui/is/templates/trigger-to-javascript.job".equals(this.model.getTemplate().getLocation())) {
            this.generateFile("/org/eclipse/dirigible/ide/template/ui/is/templates/javascript-async.js", targetLocationPathJavaScriptServices, String.valueOf(this.model.getEndpointAddress()) + ".js");
        }
    }
}

