/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.repository.rcp;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.dirigible.repository.rcp.RCPWorkspaceMapper;

public class ZipExporter {
    public static void zip(List<String> inputFolders, ZipOutputStream zipOutputStream) throws IOException {
        for (String inputFolder : inputFolders) {
            String workspaceFolder = RCPWorkspaceMapper.getMappedName(inputFolder);
            ZipExporter.zip(workspaceFolder, zipOutputStream);
        }
    }

    public static void zip(String inputFolder, ZipOutputStream zipOutputStream) throws IOException {
        File inputFile = new File(inputFolder);
        if (inputFile.isFile()) {
            ZipExporter.zipFile(inputFile, "", zipOutputStream);
        } else if (inputFile.isDirectory()) {
            ZipExporter.zipFolder(zipOutputStream, inputFile, "");
        }
        zipOutputStream.close();
    }

    public static void zipFolder(ZipOutputStream zipOutputStream, File inputFolder, String parentName) throws IOException {
        File[] contents;
        String myname = String.valueOf(parentName) + inputFolder.getName() + File.separator;
        ZipEntry folderZipEntry = new ZipEntry(myname);
        zipOutputStream.putNextEntry(folderZipEntry);
        File[] fileArray = contents = inputFolder.listFiles();
        int n = contents.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.isFile()) {
                ZipExporter.zipFile(f, myname, zipOutputStream);
            } else if (f.isDirectory()) {
                ZipExporter.zipFolder(zipOutputStream, f, myname);
            }
            ++n2;
        }
        zipOutputStream.closeEntry();
    }

    public static void zipFile(File inputFile, String parentName, ZipOutputStream zipOutputStream) throws IOException {
        ZipEntry zipEntry = new ZipEntry(parentName);
        zipOutputStream.putNextEntry(zipEntry);
        FileInputStream fileInputStream = null;
        try {
            int bytesRead;
            fileInputStream = new FileInputStream(inputFile);
            byte[] buf = new byte[1024];
            while ((bytesRead = fileInputStream.read(buf)) > 0) {
                zipOutputStream.write(buf, 0, bytesRead);
            }
            zipOutputStream.closeEntry();
        }
        finally {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
    }
}

