/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.lang.python.debugger;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.jar.JarFile;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;

public class ResourceHelper {
    public static InputStream getResourceStream(String bundle, String path) throws IOException {
        String location = Platform.getBundle((String)bundle).getLocation();
        if (location.toLowerCase().endsWith(".jar")) {
            int pos = location.indexOf("file:");
            if (pos != -1) {
                if (!(location = location.substring(pos + 5)).startsWith("/")) {
                    location = (String.valueOf(Platform.getInstallLocation().getURL().toString()) + location).substring(6);
                }
                try (JarFile file = null;){
                    file = new JarFile(location);
                    if (path.startsWith("/")) {
                        InputStream inputStream = ResourceHelper.wrapStream(file.getInputStream(file.getEntry(path.substring(1))));
                        return inputStream;
                    }
                    InputStream inputStream = ResourceHelper.wrapStream(file.getInputStream(file.getEntry(path)));
                    return inputStream;
                }
            }
            return null;
        }
        URL url = Platform.getBundle((String)bundle).getResource(path);
        return FileLocator.resolve((URL)url).openStream();
    }

    private static InputStream wrapStream(InputStream inputStream) throws IOException {
        byte[] buffer = new byte[8192];
        BufferedInputStream bufferedInput = new BufferedInputStream(inputStream);
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        try {
            int length = ((InputStream)bufferedInput).read(buffer);
            while (length > 0) {
                data.write(buffer, 0, length);
                length = ((InputStream)bufferedInput).read(buffer);
            }
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        return new ByteArrayInputStream(data.toByteArray());
    }
}

