/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.scripts.repository.impl;

import java.io.File;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ease.ui.repository.IScript;
import org.eclipse.ease.ui.repository.IScriptLocation;
import org.eclipse.ease.ui.scripts.repository.impl.FileSystemParser;
import org.eclipse.ease.ui.scripts.repository.impl.RepositoryService;
import org.eclipse.ease.ui.scripts.repository.impl.WorkspaceParser;

public class UpdateRepositoryJob
extends Job
implements IResourceChangeListener {
    private final RepositoryService fRepositoryService;
    private final Collection<IScriptLocation> fEntriesforUpdate = new HashSet<IScriptLocation>();

    public UpdateRepositoryJob(RepositoryService repositoryService) {
        super("Updating script repository");
        this.fRepositoryService = repositoryService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStatus run(IProgressMonitor monitor) {
        HashSet<IScriptLocation> locations = new HashSet<IScriptLocation>();
        Collection<IScriptLocation> collection = this.fEntriesforUpdate;
        synchronized (collection) {
            if (this.fEntriesforUpdate.isEmpty()) {
                locations.addAll((Collection<IScriptLocation>)this.fRepositoryService.getRepository().getEntries());
            } else {
                locations.addAll(this.fEntriesforUpdate);
                this.fEntriesforUpdate.clear();
            }
        }
        for (IScriptLocation location : locations) {
            for (IScript script : location.getScripts()) {
                script.setUpdatePending(true);
            }
        }
        for (IScriptLocation location : locations) {
            Object content = location.getResource();
            if (content instanceof IResource && ((IResource)content).exists()) {
                new WorkspaceParser(this.fRepositoryService).parse((IResource)content, location);
                ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
                continue;
            }
            if (content instanceof File && ((File)content).exists()) {
                new FileSystemParser(this.fRepositoryService).parse((File)content, location);
                continue;
            }
            boolean cfr_ignored_0 = content instanceof InputStream;
        }
        for (IScript script : new HashSet<IScript>(this.fRepositoryService.getScripts())) {
            if (!script.isUpdatePending()) continue;
            this.fRepositoryService.removeScript(script);
        }
        this.fRepositoryService.save();
        this.schedule(1800000L);
        return Status.OK_STATUS;
    }

    public void scheduleUpdate(long delay) {
        this.cancel();
        this.schedule(delay);
    }

    synchronized void update(IScriptLocation entry) {
        this.fEntriesforUpdate.add(entry);
        this.scheduleUpdate(300L);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        System.out.println("Base: " + (event.getResource() != null ? event.getResource().getName() : "null"));
        try {
            event.getDelta().accept(new IResourceDeltaVisitor(){

                public boolean visit(IResourceDelta delta) throws CoreException {
                    IResource resource = delta.getResource();
                    String location = "workspace:/" + resource.getFullPath();
                    System.out.println(String.valueOf(location) + ": " + delta.getKind());
                    for (IScriptLocation entry : UpdateRepositoryJob.this.fRepositoryService.getLocations()) {
                        if (!entry.getLocation().equals(location)) continue;
                        UpdateRepositoryJob.this.update(entry);
                        return false;
                    }
                    return true;
                }
            });
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }
}

