/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.scripts.repository.impl;

import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ease.Logger;
import org.eclipse.ease.service.IScriptService;
import org.eclipse.ease.service.ScriptType;
import org.eclipse.ease.tools.ResourceTools;
import org.eclipse.ease.ui.repository.IRepositoryFactory;
import org.eclipse.ease.ui.repository.IScript;
import org.eclipse.ease.ui.repository.IScriptLocation;
import org.eclipse.ease.ui.scripts.repository.impl.InputStreamParser;
import org.eclipse.ease.ui.scripts.repository.impl.RepositoryService;
import org.eclipse.ui.PlatformUI;

public class WorkspaceParser
extends InputStreamParser {
    public WorkspaceParser(RepositoryService repositoryService) {
        super(repositoryService);
    }

    public void parse(IResource resource, final IScriptLocation entry) {
        if (resource instanceof IContainer) {
            try {
                resource.accept(new IResourceVisitor(){

                    public boolean visit(IResource resource) throws CoreException {
                        if (resource instanceof IFile) {
                            WorkspaceParser.this.parse(resource, entry);
                        }
                        return entry.isRecursive();
                    }
                }, entry.isRecursive() ? 2 : 1, 0);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        } else if (resource instanceof IFile) {
            String location = "workspace:/" + resource.getFullPath();
            IScript script = this.getScriptByLocation(location);
            try {
                IScriptService scriptService = (IScriptService)PlatformUI.getWorkbench().getService(IScriptService.class);
                if (script == null) {
                    ScriptType scriptType = scriptService.getScriptType(ResourceTools.toAbsoluteLocation((Object)resource, null));
                    if (scriptType != null) {
                        script = IRepositoryFactory.eINSTANCE.createScript();
                        script.setEntry(entry);
                        script.setLocation(location);
                        Map<String, String> parameters = this.extractParameters(scriptType, ((IFile)resource).getContents());
                        script.getScriptParameters().clear();
                        script.getScriptParameters().putAll(parameters);
                        script.setTimestamp(resource.getModificationStamp());
                        this.getRepositoryService().addScript(script);
                    }
                } else if (script.getTimestamp() != resource.getModificationStamp()) {
                    ScriptType scriptType = scriptService.getScriptType(ResourceTools.toAbsoluteLocation((Object)resource, null));
                    Map<String, String> parameters = this.extractParameters(scriptType, ((IFile)resource).getContents());
                    script.setTimestamp(resource.getModificationStamp());
                    this.getRepositoryService().updateScript(script, parameters);
                } else {
                    script.setUpdatePending(false);
                }
            }
            catch (CoreException e) {
                Logger.logError((String)("Cannot read script: " + resource), (Throwable)e);
            }
        }
    }
}

