/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.view;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import org.eclipse.ease.service.EngineDescription;
import org.eclipse.ease.service.IScriptService;
import org.eclipse.ease.ui.Activator;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.menus.IWorkbenchContribution;
import org.eclipse.ui.services.IServiceLocator;

public final class EngineContributionFactory
extends CompoundContributionItem
implements IWorkbenchContribution {
    private IServiceLocator fServiceLocator;

    public void initialize(IServiceLocator serviceLocator) {
        this.fServiceLocator = serviceLocator;
    }

    protected IContributionItem[] getContributionItems() {
        ArrayList<CommandContributionItem> contributions = new ArrayList<CommandContributionItem>();
        IScriptService scriptService = (IScriptService)PlatformUI.getWorkbench().getService(IScriptService.class);
        if (scriptService != null) {
            Collection engines = scriptService.getEngines();
            ArrayList<CommandContributionItemParameter> items = new ArrayList<CommandContributionItemParameter>();
            for (EngineDescription description : engines) {
                HashMap<String, String> parameters = new HashMap<String, String>();
                parameters.put("org.eclipse.ease.commands.scriptShell.switchEngine.id", description.getID());
                CommandContributionItemParameter contributionParameter = new CommandContributionItemParameter(this.fServiceLocator, null, "org.eclipse.ease.commands.scriptShell.switchEngine", 8);
                contributionParameter.parameters = parameters;
                contributionParameter.label = description.getName();
                contributionParameter.visibleEnabled = true;
                contributionParameter.icon = Activator.getImageDescriptor("/icons/eobj16/engine.png");
                items.add(contributionParameter);
            }
            Collections.sort(items, new Comparator<CommandContributionItemParameter>(){

                @Override
                public int compare(CommandContributionItemParameter o1, CommandContributionItemParameter o2) {
                    return o1.label.compareTo(o2.label);
                }
            });
            for (CommandContributionItemParameter item : items) {
                contributions.add(new CommandContributionItem(item));
            }
        }
        return contributions.toArray(new IContributionItem[contributions.size()]);
    }

    public boolean isDirty() {
        return true;
    }
}

