/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.completion.provider;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.ease.ICompletionContext;
import org.eclipse.ease.Logger;
import org.eclipse.ease.ui.completion.AbstractCompletionProvider;
import org.eclipse.ease.ui.completion.IHelpResolver;
import org.eclipse.ease.ui.completion.provider.JavaMethodCompletionProvider;
import org.eclipse.ease.ui.help.hovers.JavaPackageHelpResolver;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public class JavaPackagesCompletionProvider
extends AbstractCompletionProvider {
    private static Map<String, Collection<String>> PACKAGES = null;

    @Override
    public boolean isActive(ICompletionContext context) {
        return super.isActive(context) && (context.getType() == ICompletionContext.Type.NONE || context.getType() == ICompletionContext.Type.PACKAGE);
    }

    @Override
    protected void prepareProposals(ICompletionContext context) {
        String parentPackage;
        String string = parentPackage = context.getType() == ICompletionContext.Type.NONE ? "" : context.getPackage();
        if (JavaPackagesCompletionProvider.getPackages().get(parentPackage) != null) {
            for (String packageName : JavaPackagesCompletionProvider.getPackages().get(parentPackage)) {
                if (!this.matchesFilter(packageName)) continue;
                JavaPackageHelpResolver helpResolver = new JavaPackageHelpResolver(String.valueOf(parentPackage) + "." + packageName);
                if (parentPackage.isEmpty()) {
                    this.addProposal(packageName, String.valueOf(packageName) + ".", JavaMethodCompletionProvider.getSharedImage("org.eclipse.jdt.ui.package_obj.gif"), 60, (IHelpResolver)helpResolver);
                    continue;
                }
                this.addProposal(String.valueOf(parentPackage) + "." + packageName, String.valueOf(packageName) + ".", JavaMethodCompletionProvider.getSharedImage("org.eclipse.jdt.ui.package_obj.gif"), 60, (IHelpResolver)helpResolver);
            }
        }
    }

    public static Map<String, Collection<String>> getPackages() {
        if (PACKAGES == null) {
            PACKAGES = new HashMap<String, Collection<String>>();
            try {
                String packageName;
                URL url = new URL("platform:/plugin/org.eclipse.ease.ui/resources/java" + System.getProperty("java.runtime.version").charAt(2) + " packages.txt");
                InputStream inputStream = url.openConnection().getInputStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
                while ((packageName = reader.readLine()) != null) {
                    JavaPackagesCompletionProvider.registerPackage(packageName);
                }
                reader.close();
            }
            catch (IOException e) {
                Logger.error((String)"org.eclipse.ease.ui", (String)"Cannot read package list for code completion", (Throwable)e);
            }
            BundleContext context = FrameworkUtil.getBundle(JavaPackagesCompletionProvider.class).getBundleContext();
            Bundle[] bundleArray = context.getBundles();
            int n = bundleArray.length;
            int n2 = 0;
            while (n2 < n) {
                Bundle bundle = bundleArray[n2];
                for (String packageName : JavaPackagesCompletionProvider.getExportedPackages(bundle)) {
                    JavaPackagesCompletionProvider.registerPackage(packageName);
                }
                ++n2;
            }
        }
        return PACKAGES;
    }

    public static Collection<String> getExportedPackages(Bundle bundle) {
        HashSet<String> exportedPackages = new HashSet<String>();
        String exportPackage = (String)bundle.getHeaders().get("Export-Package");
        if (exportPackage != null) {
            String[] packages;
            String[] stringArray = packages = exportPackage.split(",");
            int n = packages.length;
            int n2 = 0;
            while (n2 < n) {
                String packageEntry = stringArray[n2];
                String candidate = packageEntry.trim().split(";")[0];
                if (candidate.endsWith("\"")) {
                    candidate = candidate.substring(0, candidate.length() - 1);
                }
                if (!(candidate.contains(".internal") || packageEntry.contains(";x-internal:=true") || candidate.startsWith("Lib") || candidate.startsWith("about_files") || candidate.startsWith("META"))) {
                    exportedPackages.add(candidate);
                }
                ++n2;
            }
        }
        return exportedPackages;
    }

    private static void registerPackage(String packageName) {
        String value;
        int lastIndex = packageName.lastIndexOf(46);
        String key = lastIndex == -1 ? "" : packageName.substring(0, lastIndex);
        String string = value = lastIndex == -1 ? packageName : packageName.substring(lastIndex + 1);
        if (!PACKAGES.containsKey(key)) {
            PACKAGES.put(key, new HashSet());
        }
        PACKAGES.get(key).add(value);
        if (!key.isEmpty()) {
            JavaPackagesCompletionProvider.registerPackage(key);
        }
    }

    public static boolean containsPackage(String candidate) {
        Collection<String> packageList;
        int lastDot = candidate.lastIndexOf(46);
        Collection<String> collection = packageList = lastDot > 0 ? JavaPackagesCompletionProvider.getPackages().get(candidate.substring(0, lastDot)) : JavaPackagesCompletionProvider.getPackages().get("");
        if (packageList != null) {
            return packageList.contains(candidate.substring(lastDot + 1));
        }
        return false;
    }
}

