/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.lang.groovy;

import java.util.regex.Pattern;

public class GroovyHelper {
    public static boolean isSaveName(String identifier) {
        return Pattern.matches("[a-zA-Z_$][a-zA-Z0-9_$]*", identifier);
    }

    public static String getSaveName(String identifier) {
        if (GroovyHelper.isSaveName(identifier)) {
            return identifier;
        }
        StringBuilder buffer = new StringBuilder(identifier.replaceAll("[^a-zA-Z0-9]", "_"));
        while (buffer.length() > 0 && buffer.charAt(0) == '_') {
            buffer.deleteCharAt(0);
        }
        while (buffer.length() > 0 && buffer.charAt(buffer.length() - 1) == '_') {
            buffer.deleteCharAt(buffer.length() - 1);
        }
        if (buffer.length() > 0) {
            char start = buffer.charAt(0);
            if (start < 'A' || start > 'Z' && start < 'a' || start > 'z') {
                buffer.insert(0, '_');
            }
        } else {
            buffer.insert(0, '_');
        }
        return buffer.toString();
    }
}

