/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.debugging;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.ease.Script;
import org.eclipse.ease.debugging.IScriptDebugFrame;
import org.eclipse.ease.debugging.ScriptDebugValue;

public class ScriptDebugFrame
implements IScriptDebugFrame {
    private final Script fScript;
    private int fLineNumber;
    private final int fType;

    public ScriptDebugFrame(Script script, int lineNumber, int type) {
        this.fScript = script;
        this.fLineNumber = lineNumber;
        this.fType = type;
    }

    public ScriptDebugFrame(IScriptDebugFrame frame) {
        this(frame.getScript(), frame.getLineNumber(), frame.getType());
    }

    @Override
    public int getLineNumber() {
        return this.fLineNumber;
    }

    @Override
    public Script getScript() {
        return this.fScript;
    }

    @Override
    public int getType() {
        return this.fType;
    }

    @Override
    public String getName() {
        return this.getScript().getTitle();
    }

    @Override
    public Map<String, Object> getVariables() {
        return Collections.emptyMap();
    }

    @Override
    public Map<String, Object> getVariables(Object parent) {
        LinkedHashMap<String, Object> variables;
        block14: {
            block15: {
                block23: {
                    block22: {
                        block21: {
                            block20: {
                                block19: {
                                    block18: {
                                        block17: {
                                            block16: {
                                                variables = new LinkedHashMap<String, Object>();
                                                if (parent == null || ScriptDebugValue.isSimpleType(parent)) break block14;
                                                if (!parent.getClass().isArray()) break block15;
                                                if (!(parent instanceof Object[])) break block16;
                                                int index = 0;
                                                while (index < ((Object[])parent).length) {
                                                    variables.put("[" + index + "]", ((Object[])parent)[index]);
                                                    ++index;
                                                }
                                                break block14;
                                            }
                                            if (!(parent instanceof char[])) break block17;
                                            int index = 0;
                                            while (index < ((char[])parent).length) {
                                                variables.put("[" + index + "]", Character.valueOf(((char[])parent)[index]));
                                                ++index;
                                            }
                                            break block14;
                                        }
                                        if (!(parent instanceof byte[])) break block18;
                                        int index = 0;
                                        while (index < ((byte[])parent).length) {
                                            variables.put("[" + index + "]", ((byte[])parent)[index]);
                                            ++index;
                                        }
                                        break block14;
                                    }
                                    if (!(parent instanceof boolean[])) break block19;
                                    int index = 0;
                                    while (index < ((boolean[])parent).length) {
                                        variables.put("[" + index + "]", ((boolean[])parent)[index]);
                                        ++index;
                                    }
                                    break block14;
                                }
                                if (!(parent instanceof short[])) break block20;
                                int index = 0;
                                while (index < ((short[])parent).length) {
                                    variables.put("[" + index + "]", ((short[])parent)[index]);
                                    ++index;
                                }
                                break block14;
                            }
                            if (!(parent instanceof int[])) break block21;
                            int index = 0;
                            while (index < ((int[])parent).length) {
                                variables.put("[" + index + "]", ((int[])parent)[index]);
                                ++index;
                            }
                            break block14;
                        }
                        if (!(parent instanceof long[])) break block22;
                        int index = 0;
                        while (index < ((long[])parent).length) {
                            variables.put("[" + index + "]", ((long[])parent)[index]);
                            ++index;
                        }
                        break block14;
                    }
                    if (!(parent instanceof double[])) break block23;
                    int index = 0;
                    while (index < ((double[])parent).length) {
                        variables.put("[" + index + "]", ((double[])parent)[index]);
                        ++index;
                    }
                    break block14;
                }
                if (!(parent instanceof float[])) break block14;
                int index = 0;
                while (index < ((float[])parent).length) {
                    variables.put("[" + index + "]", Float.valueOf(((float[])parent)[index]));
                    ++index;
                }
                break block14;
            }
            Field[] fieldArray = this.getFields(parent.getClass());
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                try {
                    if (!Modifier.isStatic(field.getModifiers())) {
                        if (!field.isAccessible()) {
                            field.setAccessible(true);
                        }
                        variables.put(field.getName(), field.get(parent));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++n2;
            }
        }
        return variables;
    }

    private Field[] getFields(Class<?> currentClass) {
        ArrayList<Field> fields = new ArrayList<Field>();
        while (currentClass != null) {
            fields.addAll(Arrays.asList(currentClass.getDeclaredFields()));
            currentClass = currentClass.getSuperclass();
        }
        return fields.toArray(new Field[0]);
    }

    @Override
    public void setLineNumber(int lineNumber) {
        this.fLineNumber = lineNumber;
    }
}

