/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.scripts.repository.impl;

import java.io.File;
import java.net.URI;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.ease.ui.scripts.repository.IRepositoryService;
import org.eclipse.ease.ui.scripts.repository.IScriptLocation;
import org.eclipse.ease.ui.scripts.repository.impl.WorkspaceParser;
import org.eclipse.ui.PlatformUI;

public class FileSystemParser
extends WorkspaceParser {
    public void parse(File file, IScriptLocation entry) {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                if (child.isFile() || entry.isRecursive()) {
                    this.parse(child, entry);
                }
                ++n2;
            }
        } else {
            String location = URIUtil.toUnencodedString((URI)file.toURI()).toString();
            IRepositoryService repositoryService = (IRepositoryService)PlatformUI.getWorkbench().getService(IRepositoryService.class);
            repositoryService.updateLocation(entry, location, file.lastModified());
        }
    }
}

