/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.ease.ICodeFactory;
import org.eclipse.ease.ICodeParser;
import org.eclipse.ease.Logger;
import org.eclipse.ease.service.EngineDescription;
import org.eclipse.ease.service.IScriptService;
import org.eclipse.ease.service.ScriptService;

public class ScriptType {
    private static final String NAME = "name";
    private static final String DEFAULT_EXTENSION = "defaultExtension";
    private static final String BINDING = "binding";
    private static final String CODE_PARSER = "codeParser";
    private static final String CODE_FACTORY = "codeFactory";
    private static final String CONTENT_TYPE = "contentType";
    private final IConfigurationElement fConfigurationElement;

    public ScriptType(IConfigurationElement configurationElement) {
        this.fConfigurationElement = configurationElement;
    }

    public String getName() {
        return this.fConfigurationElement.getAttribute(NAME);
    }

    public String getDefaultExtension() {
        return this.fConfigurationElement.getAttribute(DEFAULT_EXTENSION);
    }

    public Collection<String> getContentTypes() {
        HashSet<String> result = new HashSet<String>();
        IConfigurationElement[] iConfigurationElementArray = this.fConfigurationElement.getChildren(BINDING);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement binding = iConfigurationElementArray[n2];
            result.add(binding.getAttribute(CONTENT_TYPE));
            ++n2;
        }
        return result;
    }

    public ICodeParser getCodeParser() {
        try {
            Object parser = this.fConfigurationElement.createExecutableExtension(CODE_PARSER);
            if (parser instanceof ICodeParser) {
                return (ICodeParser)parser;
            }
        }
        catch (CoreException e) {
            Logger.error("org.eclipse.ease", "Could not instantiate code parser", e);
        }
        return null;
    }

    public ICodeFactory getCodeFactory() {
        try {
            Object factory = this.fConfigurationElement.createExecutableExtension(CODE_FACTORY);
            if (factory instanceof ICodeFactory) {
                return (ICodeFactory)factory;
            }
        }
        catch (CoreException e) {
            Logger.error("org.eclipse.ease", "Could not instantiate code factory", e);
        }
        return null;
    }

    public List<EngineDescription> getEngines() {
        ArrayList<EngineDescription> engines = new ArrayList<EngineDescription>();
        IScriptService scriptService = ScriptService.getService();
        for (EngineDescription description : scriptService.getEngines()) {
            if (!description.getSupportedScriptTypes().contains(this)) continue;
            engines.add(description);
        }
        Collections.sort(engines, new Comparator<EngineDescription>(){

            @Override
            public int compare(EngineDescription o1, EngineDescription o2) {
                return o2.getPriority() - o1.getPriority();
            }
        });
        return engines;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ScriptType) {
            return this.getName().equals(((ScriptType)obj).getName());
        }
        return super.equals(obj);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getName() == null ? 0 : this.getName().hashCode());
        result = 31 * result + (this.getDefaultExtension() == null ? 0 : this.getDefaultExtension().hashCode());
        return result;
    }
}

