/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.lang.unittest.ui.views;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.ease.lang.unittest.runtime.ITestClass;
import org.eclipse.ease.lang.unittest.runtime.ITestContainer;
import org.eclipse.ease.lang.unittest.runtime.ITestEntity;
import org.eclipse.ease.lang.unittest.runtime.ITestFile;
import org.eclipse.ease.lang.unittest.runtime.ITestFolder;
import org.eclipse.ease.lang.unittest.runtime.ITestSuite;
import org.eclipse.ease.lang.unittest.ui.Activator;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class TestSuiteLabelProvider
extends LabelProvider {
    private final LocalResourceManager fResourceManager;
    private final WorkbenchLabelProvider fWorkbenchLabelProvider = new WorkbenchLabelProvider();

    public TestSuiteLabelProvider(LocalResourceManager resourceManager) {
        this.fResourceManager = resourceManager;
    }

    public String getText(Object element) {
        if (element instanceof ITestEntity) {
            return ((ITestEntity)element).getName();
        }
        return super.getText(element);
    }

    public Image getImage(Object element) {
        if (this.isRootElement(element)) {
            if ("workspace".equals(((ITestEntity)element).getName())) {
                return Activator.getImage("org.eclipse.ease.lang.unittest.ui", "/icons/eobj16/workspace.png", true);
            }
            return Activator.getImage("org.eclipse.ease.lang.unittest.ui", "/icons/eobj16/file_system.png", true);
        }
        if (element instanceof ITestFolder) {
            if (this.isRootElement(((ITestFolder)element).getParent()) && "workspace".equals(((ITestFolder)element).getParent().getName())) {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_PROJECT");
            }
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
        }
        if (element instanceof ITestFile) {
            Object file = ((ITestFile)element).getResource();
            if (file instanceof IFile) {
                return this.fWorkbenchLabelProvider.getImage(file);
            }
            if (file instanceof File) {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
            }
        } else if (element instanceof ITestSuite) {
            Object file = ((ITestSuite)element).getResource();
            if (file instanceof IFile) {
                return this.fWorkbenchLabelProvider.getImage(file);
            }
            if (file instanceof File) {
                return this.fResourceManager.createImage(Activator.getImageDescriptor("org.eclipse.ease.lang.unittest.ui", "/icons/eobj16/testsuite.png"));
            }
        } else if (element instanceof ITestClass) {
            return this.fResourceManager.createImage(Activator.getImageDescriptor("org.eclipse.ease.lang.unittest.ui", "/icons/eobj16/testclass.png"));
        }
        return super.getImage(element);
    }

    protected boolean isRootElement(Object element) {
        if (element instanceof ITestContainer) {
            return ((ITestContainer)element).getParent() == null;
        }
        return false;
    }

    public void dispose() {
        this.fWorkbenchLabelProvider.dispose();
        super.dispose();
    }
}

