/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.views.shell.dropins;

import java.time.Duration;
import org.eclipse.ease.IExecutionListener;
import org.eclipse.ease.IReplEngine;
import org.eclipse.ease.IScriptEngine;
import org.eclipse.ease.Script;
import org.eclipse.ease.ui.views.shell.dropins.IShellDropin;
import org.eclipse.jface.util.Throttler;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPartSite;

public abstract class AbstractDropin
implements IShellDropin,
IExecutionListener {
    private IReplEngine fEngine;
    private final Throttler fUiUpdater = new Throttler(Display.getDefault(), Duration.ofMillis(500L), this::update);
    private boolean fIsActive = false;
    private boolean fGloballyHidden = false;

    @Override
    public void setScriptEngine(IReplEngine engine) {
        if (this.fEngine != null) {
            this.fEngine.removeExecutionListener((IExecutionListener)this);
        }
        this.fEngine = engine;
        if (this.fEngine != null) {
            this.fEngine.addExecutionListener((IExecutionListener)this);
        }
    }

    @Override
    public Composite createPartControl(IWorkbenchPartSite site, Composite parent) {
        Composite composite = this.createComposite(site, parent);
        this.fIsActive = true;
        composite.addListener(23, event -> {
            boolean bl = this.fIsActive = false;
        });
        composite.addListener(22, event -> {
            this.fIsActive = true;
            this.update();
        });
        return composite;
    }

    public void notify(IScriptEngine engine, Script script, int status) {
        switch (status) {
            case 4: {
                this.fUiUpdater.throttledExec();
                break;
            }
            case 2: {
                engine.removeExecutionListener((IExecutionListener)this);
                break;
            }
        }
    }

    protected void update() {
        if (!this.fGloballyHidden && this.fIsActive) {
            this.updateUI();
        }
    }

    @Override
    public void setHidden(boolean hidden) {
        this.fGloballyHidden = hidden;
    }

    protected abstract void updateUI();

    protected abstract Composite createComposite(IWorkbenchPartSite var1, Composite var2);
}

