/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.lang.javascript.rhino.debugger;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.ease.IDebugEngine;
import org.eclipse.ease.IExecutionListener;
import org.eclipse.ease.Script;
import org.eclipse.ease.debugging.ScriptStackTrace;
import org.eclipse.ease.debugging.dispatcher.EventDispatchJob;
import org.eclipse.ease.debugging.dispatcher.IEventProcessor;
import org.eclipse.ease.debugging.events.debugger.IDebuggerEvent;
import org.eclipse.ease.debugging.events.debugger.ThreadCreatedEvent;
import org.eclipse.ease.debugging.events.debugger.ThreadTerminatedEvent;
import org.eclipse.ease.debugging.model.EaseDebugTarget;
import org.eclipse.ease.debugging.model.EaseDebugVariable;
import org.eclipse.ease.lang.javascript.JavaScriptHelper;
import org.eclipse.ease.lang.javascript.rhino.RhinoScriptEngine;
import org.eclipse.ease.lang.javascript.rhino.debugger.LineNumberDebugger;
import org.eclipse.ease.lang.javascript.rhino.debugger.RhinoDebugger;
import org.eclipse.ease.lang.javascript.rhino.debugger.model.RhinoDebugTarget;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.debug.Debugger;

public class RhinoDebuggerEngine
extends RhinoScriptEngine
implements IDebugEngine,
ContextFactory.Listener {
    public static final String ENGINE_ID = "org.eclipse.ease.javascript.rhinoDebugger";
    private RhinoDebugger fDebugger = new LineNumberDebugger(this);

    public static boolean isSimpleType(Object value) {
        return value instanceof Integer || value instanceof Byte || value instanceof Short || value instanceof Boolean || value instanceof Character || value instanceof Long || value instanceof Double || value instanceof Float;
    }

    public RhinoDebuggerEngine() {
        super("Rhino Debugger");
    }

    @Override
    protected synchronized void setupEngine() {
        super.setupEngine();
        Context context = RhinoDebuggerEngine.getContext();
        context.setOptimizationLevel(-1);
        context.setGeneratingDebug(true);
        context.setGeneratingSource(true);
        context.setDebugger((Debugger)this.fDebugger, null);
        context.getFactory().addListener((ContextFactory.Listener)this);
    }

    @Override
    protected synchronized void teardownEngine() {
        RhinoDebuggerEngine.getContext().getFactory().removeListener((ContextFactory.Listener)this);
        super.teardownEngine();
    }

    @Override
    protected Collection<EaseDebugVariable> getDefinedVariables(Object scope) {
        if (scope instanceof RhinoDebugger.RhinoDebugFrame) {
            HashSet<EaseDebugVariable> result = new HashSet<EaseDebugVariable>();
            Map<String, Object> variables = ((RhinoDebugger.RhinoDebugFrame)((Object)scope)).getVariables();
            for (Map.Entry<String, Object> entry : variables.entrySet()) {
                if (!this.acceptVariable(entry.getValue())) continue;
                EaseDebugVariable variable = this.createVariable(entry.getKey(), entry.getValue());
                result.add(variable);
            }
            EaseDebugTarget debugTarget = new EaseDebugTarget(null, false, false, false){

                protected IBreakpoint[] getBreakpoints(Script script) {
                    return null;
                }

                public boolean supportsBreakpoint(IBreakpoint breakpoint) {
                    return false;
                }
            };
            for (EaseDebugVariable entry : result) {
                entry.setParent((IDebugElement)debugTarget);
            }
            return result;
        }
        return super.getDefinedVariables(scope);
    }

    public Collection<EaseDebugVariable> getVariables(Object scope) {
        return this.getDefinedVariables(scope);
    }

    @Override
    protected boolean acceptVariable(Object value) {
        if (value != null && "org.mozilla.javascript.InterpretedFunction".equals(value.getClass().getName())) {
            return false;
        }
        return super.acceptVariable(value);
    }

    public Object removeVariable(String name) {
        Object result = this.getVariable(name);
        this.getScope().delete(name);
        return result;
    }

    public void setVariable(String name, Object content, Scriptable scope) {
        if (!JavaScriptHelper.isSaveName((String)name)) {
            throw new RuntimeException("\"" + name + "\" is not a valid JavaScript variable name");
        }
        Object jsOut = this.internaljavaToJS(content, scope);
        scope.put(name, scope, jsOut);
    }

    @Override
    public void setOptimizationLevel(int level) {
    }

    public void setupDebugger(ILaunch launch, boolean suspendOnStartup, boolean suspendOnScriptLoad, boolean showDynamicCode) {
        this.removeExecutionListener((IExecutionListener)this.fDebugger);
        RhinoDebugTarget debugTarget = new RhinoDebugTarget(launch, suspendOnStartup, suspendOnScriptLoad, showDynamicCode);
        launch.addDebugTarget((IDebugTarget)debugTarget);
        this.fDebugger = new RhinoDebugger(this, showDynamicCode);
        new EventDispatchJob((IEventProcessor)debugTarget, (IEventProcessor)this.fDebugger);
    }

    public ScriptStackTrace getStackTrace() {
        return this.fDebugger.getStacktrace();
    }

    @Override
    public ScriptStackTrace getExceptionStackTrace() {
        if (this.fDebugger.getExceptionStacktrace() == null || this.fDebugger.getExceptionStacktrace().isEmpty()) {
            return super.getExceptionStackTrace();
        }
        return this.fDebugger.getExceptionStacktrace();
    }

    public ScriptStackTrace getExceptionStackTrace(Object thread) {
        if (this.fDebugger.getExceptionStacktrace(thread) == null || this.fDebugger.getExceptionStacktrace(thread).isEmpty()) {
            return super.getExceptionStackTrace();
        }
        return this.fDebugger.getExceptionStacktrace(thread);
    }

    public void contextCreated(Context cx) {
        cx.setDebugger((Debugger)this.fDebugger, null);
        this.fDebugger.fireDispatchEvent((IDebuggerEvent)new ThreadCreatedEvent());
    }

    public void contextReleased(Context cx) {
        cx.setDebugger(null, null);
        this.fDebugger.fireDispatchEvent((IDebuggerEvent)new ThreadTerminatedEvent());
    }
}

