/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.modules;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Path;
import org.eclipse.ease.ICodeFactory;
import org.eclipse.ease.IScriptEngine;
import org.eclipse.ease.Logger;
import org.eclipse.ease.modules.ModuleDefinition;
import org.eclipse.ease.modules.ScriptParameter;
import org.eclipse.ease.modules.WrapToScript;
import org.eclipse.ease.service.IScriptService;
import org.eclipse.ease.service.ScriptService;

public final class ModuleHelper {
    @Deprecated
    private ModuleHelper() {
    }

    public static List<Method> getMethods(Class<?> clazz) {
        try {
            if (clazz == null || clazz.getMethods().length == 0) {
                return Collections.emptyList();
            }
        }
        catch (NoClassDefFoundError e) {
            Logger.warning("org.eclipse.ease", "The class " + clazz.getName() + " is broken", e);
            return Collections.emptyList();
        }
        ArrayList<Method> methods = new ArrayList<Method>();
        boolean wrapping = ModuleHelper.hasWrapToScript(clazz);
        Method[] methodArray = clazz.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (Modifier.isPublic(method.getModifiers()) && (!wrapping || method.isAnnotationPresent(WrapToScript.class)) && !Object.class.equals(method.getDeclaringClass())) {
                methods.add(method);
            }
            ++n2;
        }
        return methods;
    }

    public static List<Field> getFields(Class<?> clazz) {
        if (clazz == null || clazz.getDeclaredFields().length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Field> fields = new ArrayList<Field>();
        boolean wrapping = ModuleHelper.hasWrapToScript(clazz);
        Field[] fieldArray = clazz.getFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (Modifier.isFinal(field.getModifiers()) && Modifier.isPublic(field.getModifiers()) && (!wrapping || field.isAnnotationPresent(WrapToScript.class))) {
                fields.add(field);
            }
            ++n2;
        }
        return fields;
    }

    private static boolean hasWrapToScript(Class<?> clazz) {
        AccessibleObject[] accessibleObjectArray = clazz.getDeclaredFields();
        int n = accessibleObjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = accessibleObjectArray[n2];
            if (field.isAnnotationPresent(WrapToScript.class)) {
                return true;
            }
            ++n2;
        }
        accessibleObjectArray = clazz.getMethods();
        n = accessibleObjectArray.length;
        n2 = 0;
        while (n2 < n) {
            AccessibleObject method = accessibleObjectArray[n2];
            if (method.isAnnotationPresent(WrapToScript.class)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static ModuleDefinition resolveModuleName(String identifier) {
        Path searchPath = new Path(identifier);
        IScriptService scriptService = ScriptService.getService();
        Collection<ModuleDefinition> availableModules = scriptService.getAvailableModules();
        ModuleDefinition candidate = null;
        for (ModuleDefinition definition : availableModules) {
            if (definition.getPath().equals((Object)searchPath)) {
                return definition;
            }
            if (searchPath.segmentCount() != 1 || searchPath.isAbsolute() || !definition.getPath().lastSegment().equals(searchPath.lastSegment())) continue;
            if (candidate != null) {
                throw new RuntimeException("Module identifier \"" + identifier + "\" is ambiguous. Use full path name to load.");
            }
            candidate = definition;
        }
        return candidate;
    }

    public static Collection<ModuleDefinition> getLoadedModules(IScriptEngine engine) {
        HashSet<ModuleDefinition> modules = new HashSet<ModuleDefinition>();
        IScriptService scriptService = ScriptService.getService();
        block0: for (Map.Entry<String, Object> entry : engine.getVariables().entrySet()) {
            if (!entry.getKey().startsWith("__EASE_MOD_")) continue;
            Class<?> moduleClass = entry.getValue().getClass();
            for (ModuleDefinition definition : scriptService.getAvailableModules()) {
                if (!definition.getModuleClass().equals(moduleClass)) continue;
                modules.add(definition);
                continue block0;
            }
        }
        return modules;
    }

    public static List<ICodeFactory.Parameter> getParameters(Method method) {
        ArrayList<ICodeFactory.Parameter> parameters = new ArrayList<ICodeFactory.Parameter>();
        int index = 0;
        while (index < method.getParameters().length) {
            ICodeFactory.Parameter parameter = new ICodeFactory.Parameter();
            parameter.setClass(method.getParameters()[index].getType());
            parameter.setName(method.getParameters()[index].getName());
            ScriptParameter annotation = ModuleHelper.getParameterAnnotation(method.getParameters()[index].getAnnotations());
            if (annotation != null) {
                parameter.setOptional(ScriptParameter.Helper.isOptional(annotation));
                parameter.setDefault(annotation.defaultValue());
            }
            parameters.add(parameter);
            ++index;
        }
        for (ICodeFactory.Parameter parameter : parameters) {
            if (!parameter.getName().isEmpty()) continue;
            parameter.setName(ModuleHelper.findName(parameters));
        }
        return parameters;
    }

    private static ScriptParameter getParameterAnnotation(Annotation[] annotations) {
        Annotation[] annotationArray = annotations;
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            if (annotation instanceof ScriptParameter) {
                return (ScriptParameter)annotation;
            }
            ++n2;
        }
        return null;
    }

    private static String findName(List<ICodeFactory.Parameter> parameters) {
        String name;
        boolean found;
        int index = 1;
        block0: do {
            found = true;
            name = "param" + index;
            for (ICodeFactory.Parameter parameter : parameters) {
                if (!name.equals(parameter.getName())) continue;
                ++index;
                found = false;
                continue block0;
            }
        } while (!found);
        return name;
    }

    public static boolean isDeprecated(AccessibleObject element) {
        if (element instanceof Method) {
            return element.getAnnotation(Deprecated.class) != null || ((Method)element).getDeclaringClass().getAnnotation(Deprecated.class) != null;
        }
        if (element instanceof Field) {
            return element.getAnnotation(Deprecated.class) != null || ((Field)element).getDeclaringClass().getAnnotation(Deprecated.class) != null;
        }
        return element.getAnnotation(Deprecated.class) != null;
    }
}

