/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.cdo.internal.core;

import org.eclipse.emf.ecp.core.ECPProvider;
import org.eclipse.emf.ecp.core.ECPRepository;
import org.eclipse.emf.ecp.core.exceptions.ECPProjectWithNameExistsException;
import org.eclipse.emf.ecp.core.util.ECPCheckoutSource;
import org.eclipse.emf.ecp.core.util.ECPProperties;
import org.eclipse.emf.ecp.core.util.ECPUtil;
import org.eclipse.emf.ecp.spi.core.InternalRepository;

public class CDOBranchWrapper
implements ECPCheckoutSource {
    private final InternalRepository repository;
    private final String branchPath;

    public CDOBranchWrapper(InternalRepository repository, String branchPath) {
        this.repository = repository;
        this.branchPath = branchPath;
    }

    public ECPProvider getProvider() {
        return this.repository.getProvider();
    }

    public final InternalRepository getRepository() {
        return this.repository;
    }

    public final String getBranchPath() {
        return this.branchPath;
    }

    public String getName() {
        int pos = this.branchPath.lastIndexOf(47);
        if (pos == -1) {
            return this.branchPath;
        }
        return this.branchPath.substring(pos + 1);
    }

    public String getDefaultCheckoutName() {
        return String.valueOf(this.repository.getName()) + "." + this.getName();
    }

    public void checkout(String projectName, ECPProperties projectProperties) throws ECPProjectWithNameExistsException {
        projectProperties.addProperty("branchPath", this.branchPath);
        ECPUtil.getECPProjectManager().createProject((ECPRepository)this.getRepository(), projectName, projectProperties);
    }

    public String toString() {
        return this.getName();
    }
}

