/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.declaration.merge;

import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.edapt.declaration.EdaptConstraint;
import org.eclipse.emf.edapt.declaration.EdaptOperation;
import org.eclipse.emf.edapt.declaration.EdaptParameter;
import org.eclipse.emf.edapt.declaration.OperationImplementation;
import org.eclipse.emf.edapt.internal.common.MetamodelUtils;
import org.eclipse.emf.edapt.spi.migration.Instance;
import org.eclipse.emf.edapt.spi.migration.Metamodel;
import org.eclipse.emf.edapt.spi.migration.Model;

@EdaptOperation(identifier="replaceClass", label="Replace Class", description="In the metamodel, a class is deleted. In the model, instances of this class are migrated to another class based on a mapping of features.")
public class ReplaceClass
extends OperationImplementation {
    @EdaptParameter(main=true, description="The class to be replaced")
    public EClass toReplace;
    @EdaptParameter(description="The class by which it is replaced")
    public EClass replaceBy;
    @EdaptParameter(optional=true, description="The features to be replaced")
    public List<EStructuralFeature> featuresToReplace;
    @EdaptParameter(optional=true, description="The features by which they are replaced (in the same order)")
    public List<EStructuralFeature> featuresReplaceBy;

    @EdaptConstraint(restricts="featuresToReplace", description="The replace features must be defined in the replaced class")
    public boolean checkFeaturesToReplace(EStructuralFeature featuresToReplace) {
        return this.toReplace.getEAllStructuralFeatures().contains((Object)featuresToReplace);
    }

    @EdaptConstraint(restricts="featuresReplaceBy", description="The replacing features must be defined in the replacing class")
    public boolean checkFeaturesReplaceBy(EStructuralFeature featuresReplaceBy) {
        return this.replaceBy.getEAllStructuralFeatures().contains((Object)featuresReplaceBy);
    }

    @EdaptConstraint(description="The replace features must cover all features from the difference between the class to replace and the class by which it is replaced")
    public boolean checkCoverFeatureDifference() {
        return this.replaceBy == null || this.featuresToReplace.containsAll(MetamodelUtils.subtractFeatures((EClass)this.toReplace, (EClass)this.replaceBy));
    }

    @EdaptConstraint(description="The replaced and replacing features have to be of the same size")
    public boolean checkFeaturesSameSize() {
        return this.featuresToReplace.size() == this.featuresReplaceBy.size();
    }

    @EdaptConstraint(description="The class to be replaced must not have sub types")
    public boolean checkToReplaceNoSubTypes(Metamodel metamodel) {
        return metamodel.getESubTypes(this.toReplace).isEmpty();
    }

    @Override
    public void execute(Metamodel metamodel, Model model) {
        for (EReference reference : metamodel.getInverse((EModelElement)this.toReplace, EcorePackage.Literals.ETYPED_ELEMENT__ETYPE)) {
            reference.setEType((EClassifier)this.replaceBy);
        }
        metamodel.delete((EModelElement)this.toReplace);
        for (Instance instance : model.getAllInstances(this.toReplace)) {
            instance.migrate(this.replaceBy);
            int i = 0;
            while (i < this.featuresToReplace.size()) {
                instance.set(this.featuresReplaceBy.get(i), instance.unset(this.featuresToReplace.get(i)));
                ++i;
            }
        }
    }
}

