/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.common;

import java.util.NoSuchElementException;

public final class Optional<T> {
    private static final Optional<?> EMPTY = new Optional();
    private final T value;

    public static <T> Optional<T> empty() {
        Optional<?> t = EMPTY;
        return t;
    }

    public static <T> Optional<T> of(T value) {
        return new Optional<T>(value);
    }

    public static <T> Optional<T> ofNullable(T value) {
        if (value == null) {
            return Optional.empty();
        }
        return Optional.of(value);
    }

    private Optional() {
        this.value = null;
    }

    private Optional(T value) {
        if (value == null) {
            throw new NullPointerException("Value must not be null!");
        }
        this.value = value;
    }

    public boolean isPresent() {
        return this.value != null;
    }

    public T get() {
        if (this.value == null) {
            throw new NoSuchElementException("No value present!");
        }
        return this.value;
    }
}

