/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.spi.table.swt;

import java.util.List;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emfforms.common.Optional;

public class SelectedEnumeratorMapping {
    private boolean selected;
    private final Enumerator enumerator;

    public static Optional<SelectedEnumeratorMapping> findLiteral(SelectedEnumeratorMapping[] mapping, String literal) {
        SelectedEnumeratorMapping[] selectedEnumeratorMappingArray = mapping;
        int n = mapping.length;
        int n2 = 0;
        while (n2 < n) {
            SelectedEnumeratorMapping m = selectedEnumeratorMappingArray[n2];
            if (m.getEnumerator().getLiteral().equals(literal)) {
                return Optional.of((Object)m);
            }
            ++n2;
        }
        return Optional.empty();
    }

    public static Optional<Enumerator> findSelected(SelectedEnumeratorMapping[] mapping) {
        SelectedEnumeratorMapping[] selectedEnumeratorMappingArray = mapping;
        int n = mapping.length;
        int n2 = 0;
        while (n2 < n) {
            SelectedEnumeratorMapping current = selectedEnumeratorMappingArray[n2];
            if (current.isSelected()) {
                return Optional.of((Object)current.getEnumerator());
            }
            ++n2;
        }
        return Optional.empty();
    }

    public static SelectedEnumeratorMapping[] createFromList(List<EEnumLiteral> literals) {
        SelectedEnumeratorMapping[] mapping = new SelectedEnumeratorMapping[literals.size()];
        int i = 0;
        for (EEnumLiteral literal : literals) {
            SelectedEnumeratorMapping current = new SelectedEnumeratorMapping(literal.getInstance(), false);
            mapping[i++] = current;
        }
        return mapping;
    }

    public static void select(SelectedEnumeratorMapping[] mappings, Enumerator enumerator) {
        SelectedEnumeratorMapping[] selectedEnumeratorMappingArray = mappings;
        int n = mappings.length;
        int n2 = 0;
        while (n2 < n) {
            SelectedEnumeratorMapping selectedEnumeratorMapping = selectedEnumeratorMappingArray[n2];
            if (enumerator.equals(selectedEnumeratorMapping.getEnumerator())) {
                selectedEnumeratorMapping.setSelected(true);
            }
            ++n2;
        }
    }

    public static void deselectAll(SelectedEnumeratorMapping[] mappings) {
        SelectedEnumeratorMapping[] selectedEnumeratorMappingArray = mappings;
        int n = mappings.length;
        int n2 = 0;
        while (n2 < n) {
            SelectedEnumeratorMapping selectedMapping = selectedEnumeratorMappingArray[n2];
            selectedMapping.setSelected(false);
            ++n2;
        }
    }

    public SelectedEnumeratorMapping(Enumerator enumerator, boolean selected) {
        this.enumerator = enumerator;
        this.setSelected(selected);
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public Enumerator getEnumerator() {
        return this.enumerator;
    }
}

