/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.spi.swt.table.action;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.eclipse.emfforms.common.Optional;
import org.eclipse.emfforms.spi.swt.table.action.Action;
import org.eclipse.emfforms.spi.swt.table.action.ActionConfiguration;
import org.eclipse.emfforms.spi.swt.table.action.ActionControlCreator;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.swt.widgets.Control;

class ActionConfigurationImpl
implements ActionConfiguration {
    private final Map<String, Action> actions;
    private final Map<String, Collection<KeyStroke>> keyStrokes;
    private final Map<String, ActionControlCreator<? extends Control>> controlCreatorCallbacks;

    ActionConfigurationImpl(Map<String, Action> actions, Map<String, Collection<KeyStroke>> keySequences, Map<String, ActionControlCreator<? extends Control>> controlCreatorCallbacks) {
        this.actions = actions;
        this.keyStrokes = keySequences;
        this.controlCreatorCallbacks = controlCreatorCallbacks;
    }

    @Override
    public Optional<Action> getActionById(String id) {
        return Optional.ofNullable((Object)this.actions.get(id));
    }

    @Override
    public Collection<Action> getActions() {
        return Collections.unmodifiableCollection(this.actions.values());
    }

    @Override
    public boolean hasKeyStrokesFor(Action action) {
        return this.keyStrokes.containsKey(action.getId());
    }

    @Override
    public Collection<KeyStroke> getKeyStrokesFor(Action action) {
        return Collections.unmodifiableCollection(this.keyStrokes.get(action.getId()));
    }

    @Override
    public boolean hasControlFor(Action action) {
        return this.controlCreatorCallbacks.containsKey(action.getId());
    }

    @Override
    public ActionControlCreator<? extends Control> getControlCreator(Action action) {
        return this.controlCreatorCallbacks.get(action.getId());
    }
}

