/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.spi.model.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EDataTypeUniqueEList;
import org.eclipse.emf.ecp.view.spi.model.VDiagnostic;
import org.eclipse.emf.ecp.view.spi.model.VViewPackage;

public class VDiagnosticImpl
extends EObjectImpl
implements VDiagnostic {
    protected EList<Object> diagnostics;

    protected VDiagnosticImpl() {
    }

    protected EClass eStaticClass() {
        return VViewPackage.Literals.DIAGNOSTIC;
    }

    @Override
    public EList<Object> getDiagnostics() {
        if (this.diagnostics == null) {
            this.diagnostics = new EDataTypeUniqueEList(Object.class, (InternalEObject)this, 0);
        }
        return this.diagnostics;
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getDiagnostics();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.getDiagnostics().clear();
                this.getDiagnostics().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.getDiagnostics().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.diagnostics != null && !this.diagnostics.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (diagnostics: ");
        result.append(this.diagnostics);
        result.append(')');
        return result.toString();
    }

    @Override
    public int getHighestSeverity() {
        int highestSeverity = 0;
        if (this.getDiagnostics().size() > 0) {
            for (Object o : this.getDiagnostics()) {
                Diagnostic diagnostic = (Diagnostic)o;
                int n = highestSeverity = highestSeverity >= diagnostic.getSeverity() ? highestSeverity : diagnostic.getSeverity();
            }
        }
        return highestSeverity;
    }

    @Override
    public String getMessage() {
        String message = "";
        if (this.getDiagnostics().size() == 1) {
            Diagnostic diagnostic = (Diagnostic)Diagnostic.class.cast(this.getDiagnostics().get(0));
            if (diagnostic.getSeverity() == 0) {
                return message;
            }
            if (diagnostic.getChildren() != null && diagnostic.getChildren().size() == 0) {
                return diagnostic.getMessage();
            }
            StringBuilder sb = new StringBuilder();
            for (Diagnostic childDiagnostic : diagnostic.getChildren()) {
                if (sb.length() > 0) {
                    sb.append("\n");
                }
                sb.append(childDiagnostic.getMessage());
            }
            message = sb.toString();
        } else if (this.getDiagnostics().size() > 0) {
            Diagnostic diagnostic;
            LinkedHashMap<EObject, Diagnostic> diagnosticMap = new LinkedHashMap<EObject, Diagnostic>();
            ArrayList<Diagnostic> diagnostics = new ArrayList<Diagnostic>(this.getDiagnostics().size());
            for (Object o : this.getDiagnostics()) {
                diagnostic = (Diagnostic)o;
                diagnostics.add(diagnostic);
            }
            this.sortDiagnostics(diagnostics);
            for (Object o : diagnostics) {
                diagnostic = (Diagnostic)o;
                if (diagnostic.getSeverity() == 0 || diagnostic.getData() == null || diagnostic.getData().size() == 0 || !EObject.class.isInstance(diagnostic.getData().get(0)) || diagnosticMap.containsKey(diagnostic.getData().get(0))) continue;
                diagnosticMap.put((EObject)diagnostic.getData().get(0), diagnostic);
            }
            StringBuilder sb = new StringBuilder();
            for (Diagnostic diagnostic2 : diagnosticMap.values()) {
                if (sb.length() > 0) {
                    sb.append("\n");
                }
                sb.append(diagnostic2.getMessage());
            }
            message = sb.toString();
        }
        return message;
    }

    private void sortDiagnostics(List<Diagnostic> diagnostics) {
        Collections.sort(diagnostics, new Comparator<Diagnostic>(){

            @Override
            public int compare(Diagnostic o1, Diagnostic o2) {
                if (o1.getSeverity() != o2.getSeverity()) {
                    return o2.getSeverity() - o1.getSeverity();
                }
                return o1.getMessage().compareTo(o2.getMessage());
            }
        });
    }

    @Override
    public List<Diagnostic> getDiagnostics(EObject eObject) {
        BasicEList result = new BasicEList();
        for (Object objectDiagnostic : this.getDiagnostics()) {
            Diagnostic diagnostic = (Diagnostic)objectDiagnostic;
            if (diagnostic.getSeverity() == 0) continue;
            result.addAll(this.getDiagnostics(diagnostic, eObject));
        }
        this.sortDiagnostics((List<Diagnostic>)result);
        return result;
    }

    private List<Diagnostic> getDiagnostics(Diagnostic diagnostic, EObject eObject) {
        ArrayList<Diagnostic> result = new ArrayList<Diagnostic>();
        if (diagnostic.getData() != null && diagnostic.getData().size() != 0 && eObject.equals(diagnostic.getData().get(0))) {
            result.add(diagnostic);
        }
        return result;
    }

    @Override
    public List<Diagnostic> getDiagnostic(EObject eObject, EStructuralFeature eStructuralFeature) {
        BasicEList result = new BasicEList();
        for (Object objectDiagnostic : this.getDiagnostics()) {
            Diagnostic diagnostic = (Diagnostic)objectDiagnostic;
            if (diagnostic.getSeverity() == 0) continue;
            result.addAll(this.getDiagnostics(diagnostic, eObject, eStructuralFeature));
        }
        this.sortDiagnostics((List<Diagnostic>)result);
        return result;
    }

    private List<Diagnostic> getDiagnostics(Diagnostic diagnostic, EObject eObject, EStructuralFeature eStructuralFeature) {
        ArrayList<Diagnostic> result = new ArrayList<Diagnostic>();
        if (diagnostic.getData() != null && diagnostic.getData().size() > 1 && eObject.equals(diagnostic.getData().get(0)) && eStructuralFeature.equals(diagnostic.getData().get(1))) {
            if (diagnostic.getChildren() == null || diagnostic.getChildren().size() == 0) {
                result.add(diagnostic);
            } else {
                for (Diagnostic childDiagnostic : diagnostic.getChildren()) {
                    if (childDiagnostic.getSeverity() == 0) continue;
                    result.add(childDiagnostic);
                }
            }
        }
        return result;
    }
}

