/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.declaration.delegation;

import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edapt.common.MetamodelFactory;
import org.eclipse.emf.edapt.declaration.EdaptConstraint;
import org.eclipse.emf.edapt.declaration.EdaptOperation;
import org.eclipse.emf.edapt.declaration.EdaptParameter;
import org.eclipse.emf.edapt.declaration.OperationImplementation;
import org.eclipse.emf.edapt.spi.migration.Instance;
import org.eclipse.emf.edapt.spi.migration.Metamodel;
import org.eclipse.emf.edapt.spi.migration.Model;

@EdaptOperation(identifier="flattenHierarchy", label="Flatten Containment Hierarchy", description="In the metamodel, a containment hierarchy is flattened. More specifically, the reference to denote the root as well as the reference to denote the children are replaced by a containment reference. In the model, the corresponding hierarchies are flattened accordingly.")
public class FlattenHierarchy
extends OperationImplementation {
    @EdaptParameter(main=true, description="The reference to denote the root node")
    public EReference rootReference;
    @EdaptParameter(description="The reference to denote the children nodes")
    public EReference childrenReference;
    @EdaptParameter(description="The reference which replaces the containment hierarchy")
    public String referenceName;

    @EdaptConstraint(restricts="rootReference", description="The root reference must be a single-valued containment reference.")
    public boolean checkRootReferenceSingleValueContainment(EReference rootReference) {
        return !rootReference.isMany() && rootReference.isContainment();
    }

    @EdaptConstraint(restricts="childrenReference", description="The children reference must be defined by the node class.")
    public boolean checkChildrenReferenceInNodeClass(EReference reference) {
        EClass nodeClass = this.rootReference.getEReferenceType();
        return nodeClass.getEStructuralFeatures().contains((Object)reference);
    }

    @EdaptConstraint(restricts="childrenReference", description="The children reference must be a multi-valued containment reference.")
    public boolean checkChildrenReferenceManyValuedContainment(EReference childrenReference) {
        return childrenReference.isMany() && childrenReference.isContainment();
    }

    @EdaptConstraint(description="The type of the children reference must be the node class.")
    public boolean checkChildrenReferenceType() {
        return this.childrenReference.getEType() == this.rootReference.getEReferenceType();
    }

    public void execute(Metamodel metamodel, Model model) {
        EClass rootClass = this.rootReference.getEContainingClass();
        EClass nodeClass = this.rootReference.getEReferenceType();
        metamodel.delete((EModelElement)this.rootReference);
        metamodel.delete((EModelElement)this.childrenReference);
        EReference containerReference = MetamodelFactory.newEReference((EClass)rootClass, (String)this.referenceName, (EClass)nodeClass, (int)0, (int)-1, (boolean)true);
        for (Instance root : model.getAllInstances(rootClass)) {
            Instance node = (Instance)root.unset((EStructuralFeature)this.rootReference);
            if (node == null) continue;
            root.add((EStructuralFeature)containerReference, (Object)node);
            this.visitNode(root, containerReference, node);
        }
    }

    private void visitNode(Instance root, EReference containerReference, Instance node) {
        List children = (List)node.unset((EStructuralFeature)this.childrenReference);
        ((List)root.get((EStructuralFeature)containerReference)).addAll(children);
        for (Instance child : children) {
            this.visitNode(root, containerReference, child);
        }
    }
}

