/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.declaration.generalization;

import java.util.ArrayList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edapt.declaration.EdaptConstraint;
import org.eclipse.emf.edapt.declaration.EdaptOperation;
import org.eclipse.emf.edapt.declaration.EdaptParameter;
import org.eclipse.emf.edapt.declaration.OperationImplementation;
import org.eclipse.emf.edapt.spi.migration.Instance;
import org.eclipse.emf.edapt.spi.migration.Metamodel;
import org.eclipse.emf.edapt.spi.migration.Model;

@EdaptOperation(identifier="specializeReference", label="Specialize Reference", description="In the metamodel, either the type or the multiplicity of a reference is specialized. In the model, values no longer conforming to the new type or multiplicity are removed.", breaking=true)
public class SpecializeReference
extends OperationImplementation {
    @EdaptParameter(main=true, description="The reference to be generalized")
    public EReference reference;
    @EdaptParameter(description="The new type of the reference")
    public EClass type;
    @EdaptParameter(description="The new lower bound of the reference")
    public int lowerBound;
    @EdaptParameter(description="The new upper bound of the reference")
    public int upperBound;

    @EdaptConstraint(restricts="type", description="The type must be the same or more special")
    public boolean checkType(EClass type) {
        return this.reference.getEReferenceType().isSuperTypeOf(type);
    }

    @EdaptConstraint(description="The multiplicity must be the same or more special")
    public boolean checkReferenceMultiplicityRestricted() {
        return this.lowerBound >= this.reference.getLowerBound() && (this.upperBound <= this.reference.getUpperBound() || this.reference.getUpperBound() == -1);
    }

    @Override
    public void initialize(Metamodel metamodel) {
        this.type = this.reference.getEReferenceType();
        this.lowerBound = this.reference.getLowerBound();
        this.upperBound = this.reference.getUpperBound();
    }

    @Override
    public void execute(Metamodel metamodel, Model model) {
        if (this.reference.getEType() != this.type) {
            this.reference.setEType((EClassifier)this.type);
            if (this.reference.getEOpposite() != null) {
                this.type.getEStructuralFeatures().add((Object)this.reference.getEOpposite());
            }
        }
        for (Instance instance : model.getAllInstances(this.reference.getEContainingClass())) {
            this.filterValueByType(instance, this.reference, this.type, model);
            this.filterValueByMultiplicity(instance, this.reference, this.upperBound, model);
        }
        this.reference.setLowerBound(this.lowerBound);
        this.reference.setUpperBound(this.upperBound);
    }

    private void filterValueByType(Instance instance, EReference reference, EClass type, Model model) {
        if (reference.isMany()) {
            ArrayList values = new ArrayList(instance.getLinks(reference));
            for (Instance value : values) {
                if (value.instanceOf(type)) continue;
                instance.remove((EStructuralFeature)reference, (Object)value);
                if (!reference.isContainment()) continue;
                model.delete(value);
            }
        } else {
            Instance value = (Instance)instance.get((EStructuralFeature)reference);
            if (value != null && !value.instanceOf(type)) {
                instance.unset((EStructuralFeature)reference);
                if (reference.isContainment()) {
                    model.delete(value);
                }
            }
        }
    }

    private void filterValueByMultiplicity(Instance instance, EReference reference, int upperBound, Model model) {
        if (reference.isMany()) {
            ArrayList values = new ArrayList(instance.getLinks(reference));
            if (upperBound == 1 && values.size() > 1) {
                int i = 0;
                for (Instance value : values) {
                    if (i >= upperBound) {
                        instance.remove((EStructuralFeature)reference, (Object)value);
                        if (reference.isContainment()) {
                            model.delete(value);
                        }
                    }
                    ++i;
                }
            }
        }
    }
}

