/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.interceptors.tests.contract.interceptorLifeCycle.environment;

import java.util.concurrent.TimeUnit;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.interceptors.tests.contract.interceptorLifeCycle.environment.AroundTimeoutThreadInterceptor;
import org.jboss.cdi.tck.interceptors.tests.contract.interceptorLifeCycle.environment.Bar;
import org.jboss.cdi.tck.interceptors.tests.contract.interceptorLifeCycle.environment.Foo;
import org.jboss.cdi.tck.interceptors.tests.contract.interceptorLifeCycle.environment.TestEndObserver;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.util.Timer;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="interceptors", version="1.2")
public class InterceptorEnvironmentTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(InterceptorEnvironmentTest.class)).build();
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER", groups={"javaee-full"})
    @SpecAssertion(section="interceptor_environment", id="b")
    public void testSameThread(Bar bar) throws InterruptedException {
        Assert.assertEquals((int)bar.ping(), (int)2);
        bar.createTimer();
        new Timer().setDelay(5L, TimeUnit.SECONDS).addStopCondition(new Timer.StopCondition(){

            @Override
            public boolean isSatisfied() {
                return TestEndObserver.toBeDestroyed.get();
            }
        }).start();
        Assert.assertNotNull((Object)Bar.timeoutAt);
        Assert.assertTrue((boolean)AroundTimeoutThreadInterceptor.threadOK.get());
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER")
    @SpecAssertion(section="interceptor_environment", id="c")
    public void testInvocationContext(Foo foo) {
        int input = 5;
        int result = 39;
        Assert.assertEquals((int)foo.count(5), (int)39);
        Assert.assertFalse((boolean)Foo.called);
    }
}

