/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.context.request;

import jakarta.enterprise.context.RequestScoped;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.inject.Inject;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.annotation.WebFilter;
import java.io.IOException;
import org.jboss.cdi.tck.tests.context.request.SimpleRequestBean;
import org.jboss.cdi.tck.util.ActionSequence;
import org.jboss.cdi.tck.util.SimpleLogger;

@WebFilter(filterName="IntrospectFilter", urlPatterns={"/introspect"})
public class IntrospectFilter
implements Filter {
    private static final SimpleLogger logger = new SimpleLogger(IntrospectFilter.class);
    @Inject
    private BeanManager beanManager;
    @Inject
    private SimpleRequestBean simpleBean;

    public void destroy() {
        this.beanManager = null;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        logger.log("Do filter...", new Object[0]);
        this.checkRequestContextActive();
        chain.doFilter(request, response);
        this.checkRequestContextActive();
        String mode = request.getParameter("mode");
        if ("collect".equals(mode)) {
            ActionSequence.addAction(IntrospectFilter.class.getName());
        }
    }

    private void checkRequestContextActive() throws ServletException {
        if (this.beanManager == null || !this.beanManager.getContext(RequestScoped.class).isActive() || this.simpleBean == null) {
            throw new ServletException("Request context is not active");
        }
        this.simpleBean.getId();
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }
}

