/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.interceptors.invocation;

import jakarta.annotation.PostConstruct;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.AroundTimeout;
import jakarta.interceptor.Interceptor;
import jakarta.interceptor.InvocationContext;
import java.io.Serializable;
import org.jboss.cdi.tck.tests.interceptors.invocation.AlmightyBinding;

@Interceptor
@AlmightyBinding
public class AlmightyInterceptor
implements Serializable {
    public static boolean methodIntercepted = false;
    public static boolean timeoutIntercepted = false;
    public static boolean lifecycleCallbackIntercepted = false;

    @AroundInvoke
    public Object alwaysReturnThis(InvocationContext ctx) throws Exception {
        methodIntercepted = true;
        return ctx.proceed();
    }

    @AroundTimeout
    public Object interceptTimeout(InvocationContext ctx) throws Exception {
        timeoutIntercepted = true;
        return ctx.proceed();
    }

    @PostConstruct
    public void postConstruct(InvocationContext ctx) {
        lifecycleCallbackIntercepted = true;
    }

    public static void reset() {
        methodIntercepted = false;
        lifecycleCallbackIntercepted = false;
    }
}

