/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.event.observer.transactional.custom;

import jakarta.enterprise.event.Observes;
import jakarta.enterprise.event.TransactionPhase;
import org.jboss.cdi.tck.tests.event.observer.transactional.custom.Giraffe;
import org.jboss.cdi.tck.util.ActionSequence;
import org.jboss.cdi.tck.util.SimpleLogger;

public class GiraffeObserver {
    private static final SimpleLogger logger = new SimpleLogger(GiraffeObserver.class);

    public void withdrawAfterCompletion(@Observes(during=TransactionPhase.AFTER_COMPLETION) Giraffe giraffe) throws Exception {
        this.logEventFired(TransactionPhase.AFTER_COMPLETION);
    }

    public void withdrawBeforeCompletion(@Observes(during=TransactionPhase.BEFORE_COMPLETION) Giraffe giraffe) throws Exception {
        this.logEventFired(TransactionPhase.BEFORE_COMPLETION);
    }

    private void logEventFired(TransactionPhase phase) {
        logger.log(phase.toString(), new Object[0]);
        ActionSequence.addAction(phase.toString());
    }
}

