/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.context.session.listener;

import jakarta.enterprise.context.SessionScoped;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.inject.Inject;
import jakarta.servlet.ServletRequestEvent;
import jakarta.servlet.ServletRequestListener;
import jakarta.servlet.annotation.WebListener;
import org.jboss.cdi.tck.tests.context.session.listener.IntrospectServlet;
import org.jboss.cdi.tck.tests.context.session.listener.SimpleSessionBean;
import org.jboss.cdi.tck.util.SimpleLogger;

@WebListener
public class TestServletRequestListener
implements ServletRequestListener {
    private static final SimpleLogger logger = new SimpleLogger(TestServletRequestListener.class);
    @Inject
    private BeanManager beanManager;
    @Inject
    private SimpleSessionBean simpleBean;

    public void requestDestroyed(ServletRequestEvent sre) {
        logger.log("Request destroyed...", new Object[0]);
        this.checkSessionContextActive();
    }

    public void requestInitialized(ServletRequestEvent sre) {
        logger.log("Request initialized...", new Object[0]);
        this.checkSessionContextActive();
    }

    private void checkSessionContextActive() throws IllegalStateException {
        try {
            if (!this.beanManager.getContext(SessionScoped.class).isActive() || this.simpleBean == null) {
                IntrospectServlet.isSessionScopeActive = false;
            }
            this.simpleBean.getId();
        }
        catch (Exception e) {
            IntrospectServlet.isSessionScopeActive = false;
        }
    }
}

