/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.event.observer.priority.contextLifecycleEvent.ee;

import jakarta.annotation.Priority;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.Destroyed;
import jakarta.enterprise.context.Initialized;
import jakarta.enterprise.context.RequestScoped;
import jakarta.enterprise.event.Observes;
import jakarta.servlet.ServletRequest;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

@ApplicationScoped
public class RequestContextLifecycleObserver {
    private List<String> initializedEvents = new CopyOnWriteArrayList<String>();
    private List<String> destroyedEvents = new CopyOnWriteArrayList<String>();

    public void firstInit(@Observes @Initialized(value=RequestScoped.class) @Priority(value=1900) ServletRequest servletRequest) {
        this.initializedEvents.add("A");
    }

    public void secondInit(@Observes @Initialized(value=RequestScoped.class) ServletRequest servletRequest) {
        this.initializedEvents.add("B");
    }

    public void thirdInit(@Observes @Initialized(value=RequestScoped.class) @Priority(value=2501) ServletRequest servletRequest) {
        this.initializedEvents.add("C");
    }

    public void firstDestroy(@Observes @Destroyed(value=RequestScoped.class) @Priority(value=2000) ServletRequest servletRequest) {
        this.destroyedEvents.add("A");
    }

    public void secondDestroy(@Observes @Destroyed(value=RequestScoped.class) ServletRequest servletRequest) {
        this.destroyedEvents.add("B");
    }

    public void thirdDestroy(@Observes @Destroyed(value=RequestScoped.class) @Priority(value=2501) ServletRequest servletRequest) {
        this.destroyedEvents.add("C");
    }

    public List<String> getDestroyedEvents() {
        return this.destroyedEvents;
    }

    public List<String> getInitializedEvents() {
        return this.initializedEvents;
    }
}

