/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.full.implementation.producer.method.lifecycle;

import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.inject.Disposes;
import jakarta.enterprise.inject.Produces;
import jakarta.enterprise.inject.Specializes;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.inject.Inject;
import org.jboss.cdi.tck.tests.full.implementation.producer.method.lifecycle.Null;
import org.jboss.cdi.tck.tests.full.implementation.producer.method.lifecycle.Pet;
import org.jboss.cdi.tck.tests.full.implementation.producer.method.lifecycle.Spider;
import org.jboss.cdi.tck.tests.full.implementation.producer.method.lifecycle.SpiderProducer;
import org.jboss.cdi.tck.tests.full.implementation.producer.method.lifecycle.Tarantula;
import org.jboss.cdi.tck.tests.full.implementation.producer.method.lifecycle.Web;

@Specializes
@Dependent
public class PreferredSpiderProducer
extends SpiderProducer {
    @Inject
    private Web web;
    private static Web injectedWeb;
    private static Tarantula tarantulaCreated;
    private static Tarantula tarantulaDestroyed;
    private static boolean destroyArgumentsSet;

    @Override
    @Produces
    @Pet
    @Specializes
    public Tarantula produceTarantula() {
        Tarantula tarantula;
        tarantulaCreated = tarantula = new Tarantula("Pete");
        PreferredSpiderProducer.resetTarantulaDestroyed();
        injectedWeb = this.web;
        return tarantula;
    }

    @Override
    @Produces
    @Null
    public Spider getNullSpider() {
        return null;
    }

    public void destroyTarantula(@Disposes @Pet Tarantula spider, BeanManager beanManager) {
        tarantulaDestroyed = spider;
        injectedWeb = this.web;
        if (beanManager != null) {
            destroyArgumentsSet = true;
        }
    }

    public static boolean isTarantulaCreated() {
        return tarantulaCreated != null;
    }

    public static boolean isTarantulaDestroyed() {
        return tarantulaDestroyed != null;
    }

    public static Tarantula getTarantulaDestroyed() {
        return tarantulaDestroyed;
    }

    public static void resetTarantulaCreated() {
        tarantulaCreated = null;
    }

    public static void resetTarantulaDestroyed() {
        tarantulaDestroyed = null;
        destroyArgumentsSet = false;
    }

    public static boolean isDestroyArgumentsSet() {
        return destroyArgumentsSet;
    }

    public static Tarantula getTarantulaCreated() {
        return tarantulaCreated;
    }

    public static Web getInjectedWeb() {
        return injectedWeb;
    }

    public static void resetInjections() {
        injectedWeb = null;
    }

    public static void reset() {
        PreferredSpiderProducer.resetTarantulaCreated();
        PreferredSpiderProducer.resetTarantulaDestroyed();
        PreferredSpiderProducer.resetInjections();
    }
}

