/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.lookup.injection.non.contextual;

import jakarta.annotation.Resource;
import jakarta.ejb.EJB;
import jakarta.inject.Inject;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.PersistenceUnit;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.jboss.cdi.tck.tests.lookup.injection.non.contextual.SessionBean;
import org.jboss.cdi.tck.tests.lookup.injection.non.contextual.Sheep;

public class TestFilter
implements Filter {
    @Inject
    private Sheep sheep;
    @Resource(name="greeting")
    String greeting;
    String game;
    SessionBean sessionBean;
    EntityManager persistenceContext;
    EntityManagerFactory persistenceUnit;
    private boolean injectionPerformedCorrectly = false;
    private boolean initializerCalled = false;
    private boolean initCalledAfterInitializer = false;
    private boolean initCalledAfterResourceInjection = false;
    private boolean initCalledAfterEJBResourceInjection = false;
    private boolean initCalledAfterPersistenceResourceInjection = false;

    @Inject
    public void initialize(Sheep sheep) {
        this.initializerCalled = sheep != null;
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletResponse resp = (HttpServletResponse)response;
        if (request.getParameter("test").equals("injection")) {
            resp.setStatus(this.injectionPerformedCorrectly ? 200 : 500);
        } else if (request.getParameter("test").equals("initializer")) {
            resp.setStatus(this.initCalledAfterInitializer ? 200 : 500);
        } else if (request.getParameter("test").equals("resource")) {
            resp.setStatus(this.initCalledAfterResourceInjection ? 200 : 500);
        } else if (request.getParameter("test").equals("ejb")) {
            resp.setStatus(this.initCalledAfterEJBResourceInjection ? 200 : 500);
        } else if (request.getParameter("test").equals("persistence")) {
            resp.setStatus(this.initCalledAfterPersistenceResourceInjection ? 200 : 500);
        } else {
            resp.setStatus(404);
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.injectionPerformedCorrectly = this.sheep != null;
        this.initCalledAfterInitializer = this.initializerCalled;
        this.initCalledAfterResourceInjection = "Hello".equals(this.greeting) && "poker".equals(this.game);
        this.initCalledAfterEJBResourceInjection = this.sessionBean.ping();
        this.initCalledAfterPersistenceResourceInjection = this.persistenceContext != null && this.persistenceUnit != null;
    }

    @Resource(name="game")
    private void setGame(String game) {
        this.game = game;
    }

    @EJB
    private void setSessionBean(SessionBean sessionBean) {
        this.sessionBean = sessionBean;
    }

    @PersistenceContext
    private void setPersistenceContext(EntityManager persistenceContext) {
        this.persistenceContext = persistenceContext;
    }

    @PersistenceUnit
    private void setPersistenceUnit(EntityManagerFactory persistenceUnit) {
        this.persistenceUnit = persistenceUnit;
    }
}

