/*
 * Copyright 2010, Red Hat, Inc., and individual contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jboss.cdi.tck.tests.context.request.ejb;

import java.util.UUID;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.enterprise.context.RequestScoped;

@RequestScoped
public class SimpleRequestBean {

    private String id;

    private static boolean beanDestroyed = false;

    @PostConstruct
    public void init() {
        id = UUID.randomUUID().toString();
    }

    @PreDestroy
    public void destroy() {
        beanDestroyed = true;
    }

    public String getId() {
        return id;
    }

    public static boolean isBeanDestroyed() {
        return beanDestroyed;
    }

    public static void reset() {
        beanDestroyed = false;
    }
}
