/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.full.extensions.beanManager.injectionPoint;

import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.spi.AnnotatedConstructor;
import jakarta.enterprise.inject.spi.AnnotatedField;
import jakarta.enterprise.inject.spi.AnnotatedMethod;
import jakarta.enterprise.inject.spi.AnnotatedParameter;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.InjectionPoint;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Set;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.full.extensions.beanManager.injectionPoint.Book;
import org.jboss.cdi.tck.tests.full.extensions.beanManager.injectionPoint.Fictional;
import org.jboss.cdi.tck.tests.full.extensions.beanManager.injectionPoint.Library;
import org.jboss.cdi.tck.tests.full.extensions.beanManager.injectionPoint.Magazine;
import org.jboss.cdi.tck.tests.full.extensions.beanManager.injectionPoint.Monograph;
import org.jboss.cdi.tck.tests.full.extensions.beanManager.injectionPoint.NotABean;
import org.jboss.shrinkwrap.api.BeanDiscoveryMode;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.impl.BeansXml;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"cdi-full"})
@SpecVersion(spec="cdi", version="2.0")
public class CreateInjectionPointTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(CreateInjectionPointTest.class)).withBeansXml(new BeansXml(BeanDiscoveryMode.ALL))).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="bm_obtain_injectionpoint", id="a")})
    public void testField() {
        AnnotatedType type = this.getCurrentManager().createAnnotatedType(Library.class);
        Assert.assertEquals((int)type.getFields().size(), (int)1);
        AnnotatedField field = (AnnotatedField)type.getFields().iterator().next();
        InjectionPoint ip = this.getCurrentManager().createInjectionPoint(field);
        this.validateParameterizedType(ip.getType(), Book.class, new Type[]{String.class});
        this.annotationSetMatches((Set<? extends Annotation>)ip.getQualifiers(), Monograph.class, Fictional.class);
        Assert.assertNull((Object)ip.getBean());
        Assert.assertEquals((Object)field.getJavaMember(), (Object)ip.getMember());
        Assert.assertNotNull((Object)ip.getAnnotated());
        Assert.assertFalse((boolean)ip.isDelegate());
        Assert.assertTrue((boolean)ip.isTransient());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="bm_obtain_injectionpoint", id="b")})
    public void testConstructorParameter() {
        AnnotatedType type = this.getCurrentManager().createAnnotatedType(Library.class);
        Assert.assertEquals((int)type.getConstructors().size(), (int)1);
        AnnotatedConstructor constructor = (AnnotatedConstructor)type.getConstructors().iterator().next();
        AnnotatedParameter parameter = (AnnotatedParameter)constructor.getParameters().get(1);
        InjectionPoint ip = this.getCurrentManager().createInjectionPoint(parameter);
        this.validateParameterizedType(ip.getType(), Book.class, new Type[]{String.class});
        this.annotationSetMatches((Set<? extends Annotation>)ip.getQualifiers(), Fictional.class);
        Assert.assertNull((Object)ip.getBean());
        Assert.assertEquals((Object)constructor.getJavaMember(), (Object)ip.getMember());
        Assert.assertNotNull((Object)ip.getAnnotated());
        Assert.assertFalse((boolean)ip.isDelegate());
        Assert.assertFalse((boolean)ip.isTransient());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="bm_obtain_injectionpoint", id="b")})
    public void testMethodParameter() {
        AnnotatedType type = this.getCurrentManager().createAnnotatedType(Library.class);
        Assert.assertEquals((int)1, (int)type.getMethods().size());
        AnnotatedMethod method = (AnnotatedMethod)type.getMethods().iterator().next();
        AnnotatedParameter parameter = (AnnotatedParameter)method.getParameters().get(2);
        InjectionPoint ip = this.getCurrentManager().createInjectionPoint(parameter);
        this.validateParameterizedType(ip.getType(), Book.class, new Type[]{Integer.class});
        this.annotationSetMatches((Set<? extends Annotation>)ip.getQualifiers(), Default.class);
        Assert.assertNull((Object)ip.getBean());
        Assert.assertEquals((Object)method.getJavaMember(), (Object)ip.getMember());
        Assert.assertNotNull((Object)ip.getAnnotated());
        Assert.assertFalse((boolean)ip.isDelegate());
        Assert.assertFalse((boolean)ip.isTransient());
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    @SpecAssertions(value={@SpecAssertion(section="bm_obtain_injectionpoint", id="c")})
    public void testInvalidField() {
        AnnotatedField<Magazine> invalidField = new AnnotatedField<Magazine>(){

            public boolean isStatic() {
                return false;
            }

            public AnnotatedType<Magazine> getDeclaringType() {
                return null;
            }

            public Type getBaseType() {
                return null;
            }

            public Set<Type> getTypeClosure() {
                return null;
            }

            public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
                return null;
            }

            public <T extends Annotation> Set<T> getAnnotations(Class<T> annotationType) {
                return null;
            }

            public Set<Annotation> getAnnotations() {
                return null;
            }

            public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
                return false;
            }

            public Field getJavaMember() {
                return null;
            }
        };
        this.getCurrentManager().createInjectionPoint((AnnotatedField)invalidField);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    @SpecAssertions(value={@SpecAssertion(section="bm_obtain_injectionpoint", id="c")})
    public void testInvalidParameter() {
        AnnotatedType type = this.getCurrentManager().createAnnotatedType(NotABean.class);
        Assert.assertEquals((int)1, (int)type.getMethods().size());
        AnnotatedMethod method = (AnnotatedMethod)type.getMethods().iterator().next();
        AnnotatedParameter parameter = (AnnotatedParameter)method.getParameters().get(0);
        this.getCurrentManager().createInjectionPoint(parameter);
    }

    private void validateParameterizedType(Type type, Class<?> rawType, Type ... types) {
        Assert.assertTrue((boolean)(type instanceof ParameterizedType));
        ParameterizedType parameterized = (ParameterizedType)type;
        Assert.assertEquals(rawType, (Object)parameterized.getRawType());
        Assert.assertTrue((boolean)Arrays.equals(types, parameterized.getActualTypeArguments()));
    }
}

