/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.invokers.basic;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.build.compatible.spi.BeanInfo;
import jakarta.enterprise.inject.build.compatible.spi.BuildCompatibleExtension;
import jakarta.enterprise.inject.build.compatible.spi.InvokerFactory;
import jakarta.enterprise.inject.build.compatible.spi.Registration;
import jakarta.enterprise.inject.build.compatible.spi.Synthesis;
import jakarta.enterprise.inject.build.compatible.spi.SyntheticComponents;
import jakarta.enterprise.invoke.Invoker;
import java.util.List;
import java.util.Set;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.invokers.InvokerHolder;
import org.jboss.cdi.tck.tests.invokers.InvokerHolderCreator;
import org.jboss.cdi.tck.tests.invokers.InvokerHolderExtensionBase;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="4.1")
public class InstanceMethodInvokerTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClass(InstanceMethodInvokerTest.class)).withClasses(MyService.class)).withBuildCompatibleExtension(TestExtension.class)).withClasses(InvokerHolder.class, InvokerHolderCreator.class, InvokerHolderExtensionBase.class)).build();
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER")
    @SpecAssertions(value={@SpecAssertion(section="using_invoker", id="a"), @SpecAssertion(section="using_invoker", id="b"), @SpecAssertion(section="using_invoker", id="c")})
    public void test(MyService service, InvokerHolder invokers) throws Exception {
        Invoker hello = invokers.get("hello");
        Assert.assertEquals((String)((String)hello.invoke((Object)service, new Object[]{0, List.of()})), (String)"foobar0[]");
        Assert.assertEquals((String)((String)hello.invoke((Object)new MyService(), new Object[]{1, List.of()})), (String)"foobar1[]");
        Assert.assertThrows(RuntimeException.class, () -> hello.invoke(null, new Object[]{2, List.of()}));
        Invoker helloDetyped = hello;
        Assert.assertEquals((Object)"foobar3[]", (Object)helloDetyped.invoke((Object)service, new Object[]{3, List.of()}));
        Assert.assertEquals((Object)"foobar4[]", (Object)helloDetyped.invoke((Object)new MyService(), new Object[]{4, List.of()}));
        Assert.assertThrows(RuntimeException.class, () -> helloDetyped.invoke(null, new Object[]{5, List.of()}));
        Invoker doSomething = invokers.get("doSomething");
        Assert.assertEquals((int)0, (int)MyService.counter);
        Assert.assertNull((Object)doSomething.invoke((Object)service, null));
        Assert.assertEquals((int)1, (int)MyService.counter);
        Assert.assertNull((Object)doSomething.invoke((Object)new MyService(), new Object[0]));
        Assert.assertEquals((int)2, (int)MyService.counter);
        Invoker fail = invokers.get("fail");
        Assert.assertNull((Object)fail.invoke((Object)service, new Object[]{false}));
        IllegalArgumentException ex = (IllegalArgumentException)Assert.expectThrows(IllegalArgumentException.class, () -> fail.invoke((Object)service, new Object[]{true}));
        Assert.assertEquals((String)"expected", (String)ex.getMessage());
    }

    @ApplicationScoped
    public static class MyService {
        public static int counter = 0;

        public String hello(int param1, List<String> param2) {
            return "foobar" + param1 + param2;
        }

        public void doSomething() {
            ++counter;
        }

        public void fail(boolean doFail) {
            if (doFail) {
                throw new IllegalArgumentException("expected");
            }
        }
    }

    public static class TestExtension
    extends InvokerHolderExtensionBase
    implements BuildCompatibleExtension {
        @Registration(types={MyService.class})
        public void myServiceRegistration(BeanInfo bean, InvokerFactory invokers) {
            this.registerInvokers(bean, invokers, Set.of("hello", "doSomething", "fail"));
        }

        @Synthesis
        public void synthesis(SyntheticComponents syn) {
            this.synthesizeInvokerHolder(syn);
        }
    }
}

