/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.logging.parser;

import com.sun.enterprise.server.logging.parser.LogParser;
import com.sun.enterprise.server.logging.parser.LogParserException;
import com.sun.enterprise.server.logging.parser.LogParserListener;
import com.sun.enterprise.server.logging.parser.ParsedLogRecord;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.BufferedReader;
import java.io.IOException;
import java.time.OffsetDateTime;

final class UniformLogParser
implements LogParser {
    private static final LocalStringManagerImpl LOCAL_STRINGS = new LocalStringManagerImpl(UniformLogParser.class);
    private static final String FIELD_SEPARATOR = "\\|";
    private static final String LOG_RECORD_BEGIN_MARKER = "[#|";
    private static final String LOG_RECORD_END_MARKER = "|#]";
    private static final int ULF_FIELD_COUNT = 6;

    UniformLogParser() {
    }

    @Override
    public void parseLog(BufferedReader reader, LogParserListener listener) throws LogParserException {
        String line = null;
        try {
            String logRecord;
            StringBuilder buffer = new StringBuilder();
            long position = 0L;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith(LOG_RECORD_BEGIN_MARKER)) {
                    logRecord = buffer.toString();
                    this.parseLogRecord(position, logRecord, listener);
                    position += (long)logRecord.length();
                    buffer = new StringBuilder();
                }
                buffer.append(line);
                buffer.append(System.lineSeparator());
            }
            logRecord = buffer.toString();
            this.parseLogRecord(position, logRecord, listener);
        }
        catch (IOException e) {
            throw new LogParserException(line, e);
        }
    }

    private void parseLogRecord(long position, String logRecord, LogParserListener listener) {
        ParsedLogRecord parsedLogRecord = this.parse(logRecord);
        if (parsedLogRecord != null) {
            listener.foundLogRecord(position, parsedLogRecord);
        }
    }

    private ParsedLogRecord parse(String logRecord) {
        int beginIndex = logRecord.indexOf(LOG_RECORD_BEGIN_MARKER);
        if (beginIndex < 0) {
            return null;
        }
        int endIndex = logRecord.lastIndexOf(LOG_RECORD_END_MARKER);
        if (endIndex < 0) {
            return null;
        }
        if (logRecord.length() < LOG_RECORD_BEGIN_MARKER.length() + LOG_RECORD_END_MARKER.length()) {
            return null;
        }
        String logData = logRecord.substring(beginIndex + LOG_RECORD_BEGIN_MARKER.length(), endIndex);
        String[] fieldValues = logData.split(FIELD_SEPARATOR);
        if (fieldValues.length < 6) {
            String msg = LOCAL_STRINGS.getLocalString("parser.illegal.ulf.record", "Illegal Uniform format log record {0} found", new Object[]{logRecord});
            throw new IllegalArgumentException(msg);
        }
        ParsedLogRecord parsedLogRecord = new ParsedLogRecord(logRecord);
        parsedLogRecord.setTimestamp(OffsetDateTime.parse(fieldValues[0], ISO_OFFSET_DATE_TIME_PARSER));
        parsedLogRecord.setLogLevel(fieldValues[1]);
        parsedLogRecord.setProductId(fieldValues[2]);
        parsedLogRecord.setLogger(fieldValues[3]);
        this.populateLogRecordFields(fieldValues[4], parsedLogRecord);
        StringBuilder message = new StringBuilder();
        message.append(fieldValues[5].trim());
        if (fieldValues.length > 6) {
            for (int i = 6; i < fieldValues.length; ++i) {
                message.append("|").append(fieldValues[i]);
            }
        }
        parsedLogRecord.setMessage(message.toString());
        return parsedLogRecord;
    }

    private void populateLogRecordFields(String fieldData, ParsedLogRecord parsedLogRecord) {
        String[] nv_pairs;
        for (String pair : nv_pairs = fieldData.split(";")) {
            String[] nameValue = pair.split("=");
            if (nameValue.length != 2) continue;
            String key = nameValue[0];
            String value = nameValue[1];
            if ("_ThreadID".equals(key)) {
                parsedLogRecord.setThreadId(LogParser.toLong(value));
                continue;
            }
            if ("_ThreadName".equals(key)) {
                parsedLogRecord.setThreadName(value);
                continue;
            }
            if ("_MessageID".equals(key)) {
                parsedLogRecord.setMessageKey(value);
                continue;
            }
            if ("_LevelValue".equals(key)) {
                parsedLogRecord.setLogLevelValue(LogParser.toInteger(value));
                continue;
            }
            parsedLogRecord.setSupplementalValue(key, value);
        }
    }
}

