/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.deploy.shared;

import com.sun.enterprise.deployment.deploy.shared.JarArchive;
import com.sun.enterprise.util.io.FileUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service
@PerLookup
public class MemoryMappedArchive
extends JarArchive
implements ReadableArchive {
    private static final System.Logger LOG = System.getLogger(MemoryMappedArchive.class.getName());
    private URI uri;
    private byte[] file;

    protected MemoryMappedArchive() {
    }

    public MemoryMappedArchive(InputStream is) throws IOException {
        this.read(is);
    }

    public MemoryMappedArchive(byte[] bits) {
        this.file = bits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MemoryMappedArchive(ReadableArchive source) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (JarOutputStream jos = new JarOutputStream(baos);){
            Enumeration elements = source.entries();
            while (elements.hasMoreElements()) {
                String elementName = (String)elements.nextElement();
                try {
                    InputStream is = source.getEntry(elementName);
                    try {
                        jos.putNextEntry(new ZipEntry(elementName));
                        FileUtils.copy((InputStream)is, (OutputStream)jos);
                    }
                    finally {
                        if (is == null) continue;
                        is.close();
                    }
                }
                finally {
                    jos.flush();
                    jos.closeEntry();
                }
            }
        }
        this.file = baos.toByteArray();
    }

    public byte[] getByteArray() {
        return this.file;
    }

    private void read(InputStream is) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        FileUtils.copy((InputStream)is, (OutputStream)baos);
        this.file = baos.toByteArray();
    }

    public void open(URI uri) throws IOException {
        File in = new File(uri);
        if (!in.exists()) {
            throw new FileNotFoundException(uri.getSchemeSpecificPart());
        }
        try (FileInputStream is = new FileInputStream(in);){
            this.read(is);
        }
    }

    public void close() throws IOException {
    }

    public boolean delete() {
        return false;
    }

    public Enumeration entries() {
        return this.entries(false).elements();
    }

    public Collection<String> getDirectories() throws IOException {
        return this.entries(true);
    }

    private Vector<String> entries(boolean directory) {
        Vector<String> entries = new Vector<String>();
        try (JarInputStream jis = new JarInputStream(new ByteArrayInputStream(this.file));){
            ZipEntry ze;
            while ((ze = jis.getNextEntry()) != null) {
                if (ze.isDirectory() != directory) continue;
                entries.add(ze.getName());
            }
        }
        catch (IOException ioe) {
            LOG.log(System.Logger.Level.WARNING, ioe.getMessage(), (Throwable)ioe);
        }
        return entries;
    }

    public Enumeration entries(Enumeration embeddedArchives) {
        return this.entries();
    }

    public boolean exists() {
        return false;
    }

    public String getPath() {
        return null;
    }

    public long getArchiveSize() throws NullPointerException, SecurityException {
        return this.file.length;
    }

    public URI getURI() {
        return this.uri;
    }

    public void setURI(URI uri) {
        this.uri = uri;
    }

    public ReadableArchive getSubArchive(String name) throws IOException {
        try (InputStream is = this.getEntry(name);){
            if (is != null) {
                MemoryMappedArchive archive;
                MemoryMappedArchive memoryMappedArchive = archive = new MemoryMappedArchive(is);
                return memoryMappedArchive;
            }
        }
        return null;
    }

    @Override
    public boolean exists(String name) throws IOException {
        return this.getEntry(name) != null;
    }

    public InputStream getEntry(String name) throws IOException {
        ZipEntry ze;
        JarInputStream jis = new JarInputStream(new ByteArrayInputStream(this.file));
        while ((ze = jis.getNextEntry()) != null) {
            if (!ze.getName().equals(name)) continue;
            return new BufferedInputStream(jis);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public JarEntry getJarEntry(String name) {
        try (JarInputStream jis = new JarInputStream(new ByteArrayInputStream(this.file));){
            JarEntry ze;
            do {
                if ((ze = jis.getNextJarEntry()) == null) return null;
            } while (!ze.getName().equals(name));
            JarEntry jarEntry = ze;
            return jarEntry;
        }
        catch (IOException e) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getEntrySize(String name) {
        try (JarInputStream jis = new JarInputStream(new ByteArrayInputStream(this.file));){
            ZipEntry ze;
            do {
                if ((ze = jis.getNextEntry()) == null) return 0L;
            } while (!ze.getName().equals(name));
            long l = ze.getSize();
            return l;
        }
        catch (IOException e) {
            LOG.log(System.Logger.Level.WARNING, "Couldn't get entry size for " + name + " in " + String.valueOf(this.file), (Throwable)e);
        }
        return 0L;
    }

    public Manifest getManifest() throws IOException {
        try (JarInputStream jis = new JarInputStream(new ByteArrayInputStream(this.file));){
            Manifest manifest = jis.getManifest();
            return manifest;
        }
    }

    public boolean renameTo(String name) {
        return false;
    }

    @Override
    public String getName() {
        return "";
    }
}

