/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.exousia.constraints.transformer;

import jakarta.servlet.HttpMethodConstraintElement;
import jakarta.servlet.ServletSecurityElement;
import jakarta.servlet.annotation.HttpMethodConstraint;
import jakarta.servlet.annotation.ServletSecurity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.glassfish.exousia.constraints.SecurityConstraint;
import org.glassfish.exousia.constraints.WebResourceCollection;

public class ElementsToConstraintsTransformer {
    public static List<SecurityConstraint> createConstraints(Set<String> urlPatterns, ServletSecurityElement servletSecurityElement) {
        if (urlPatterns.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<SecurityConstraint> constraints = new ArrayList<SecurityConstraint>();
        HashSet<String> httpMethodOmissions = new HashSet<String>();
        for (HttpMethodConstraintElement httpMethodConstraint : servletSecurityElement.getHttpMethodConstraints()) {
            constraints.add(ElementsToConstraintsTransformer.createSecurityConstraint(urlPatterns, httpMethodConstraint.getRolesAllowed(), httpMethodConstraint.getEmptyRoleSemantic(), httpMethodConstraint.getTransportGuarantee(), httpMethodConstraint.getMethodName(), Collections.emptySet()));
            httpMethodOmissions.add(httpMethodConstraint.getMethodName());
        }
        constraints.add(ElementsToConstraintsTransformer.createSecurityConstraint(urlPatterns, servletSecurityElement.getRolesAllowed(), servletSecurityElement.getEmptyRoleSemantic(), servletSecurityElement.getTransportGuarantee(), null, httpMethodOmissions));
        return constraints;
    }

    public static List<SecurityConstraint> createConstraints(Set<String> urlPatterns, ServletSecurity servletSecurity) {
        if (urlPatterns.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<SecurityConstraint> constraints = new ArrayList<SecurityConstraint>();
        HashSet<String> httpMethodOmissions = new HashSet<String>();
        for (HttpMethodConstraint httpMethodConstraint : servletSecurity.httpMethodConstraints()) {
            constraints.add(ElementsToConstraintsTransformer.createSecurityConstraint(urlPatterns, httpMethodConstraint.rolesAllowed(), httpMethodConstraint.emptyRoleSemantic(), httpMethodConstraint.transportGuarantee(), httpMethodConstraint.value(), Collections.emptySet()));
            httpMethodOmissions.add(httpMethodConstraint.value());
        }
        constraints.add(ElementsToConstraintsTransformer.createSecurityConstraint(urlPatterns, servletSecurity.value().rolesAllowed(), servletSecurity.value().value(), servletSecurity.value().transportGuarantee(), null, httpMethodOmissions));
        return constraints;
    }

    private static SecurityConstraint createSecurityConstraint(Set<String> urlPatterns, String[] rolesAllowed, ServletSecurity.EmptyRoleSemantic emptyRoleSemantic, ServletSecurity.TransportGuarantee transportGuarantee, String httpMethod, Set<String> httpMethodOmissions) {
        return new SecurityConstraint(Arrays.asList(new WebResourceCollection(urlPatterns, ElementsToConstraintsTransformer.createHttpMethods(httpMethod), httpMethodOmissions)), ElementsToConstraintsTransformer.createRolesAllowed(rolesAllowed, emptyRoleSemantic), transportGuarantee);
    }

    private static Set<String> createRolesAllowed(String[] rolesAllowed, ServletSecurity.EmptyRoleSemantic emptyRoleSemantic) {
        if (rolesAllowed != null && rolesAllowed.length > 0) {
            if (emptyRoleSemantic == ServletSecurity.EmptyRoleSemantic.DENY) {
                throw new IllegalArgumentException("Cannot use DENY with non-empty rolesAllowed");
            }
            return new HashSet<String>(Arrays.asList(rolesAllowed));
        }
        if (emptyRoleSemantic == ServletSecurity.EmptyRoleSemantic.DENY) {
            return Collections.emptySet();
        }
        return null;
    }

    private static Set<String> createHttpMethods(String httpMethod) {
        if (httpMethod == null) {
            return Collections.emptySet();
        }
        return new HashSet<String>(Arrays.asList(httpMethod));
    }
}

