/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wsit.security;

import com.sun.xml.wss.core.reference.KeyIdentifierSPI;
import java.math.BigInteger;
import java.security.cert.X509Certificate;
import java.util.Arrays;

public class SunKeyIdentifierSPI
extends KeyIdentifierSPI {
    private static final byte HEADER_LENGTH = 4;
    private static final byte HEADER_FIELD_LENGTH = 1;
    private static final byte HEADER_FIELD_VALUE_LENGTH = 3;

    @Override
    public byte[] getSubjectKeyIdentifier(X509Certificate cert) throws KeyIdentifierSPI.KeyIdentifierSPIException {
        byte[] subjectKeyIdentifier = cert.getExtensionValue("2.5.29.14");
        if (subjectKeyIdentifier == null) {
            return null;
        }
        try {
            if (subjectKeyIdentifier.length < 4) {
                throw new IllegalArgumentException("subjectKeyIdentifier too short, header is missing");
            }
            int valueLength = new BigInteger(Arrays.copyOfRange(subjectKeyIdentifier, 3, 4)).intValue();
            int expectedTotalLength = 4 + valueLength;
            if (subjectKeyIdentifier.length < expectedTotalLength) {
                throw new IllegalArgumentException(String.format("subjectKeyIdentifier too short (expected=%d, actual=%d)", expectedTotalLength, subjectKeyIdentifier.length));
            }
            if (subjectKeyIdentifier.length > expectedTotalLength) {
                throw new IllegalArgumentException(String.format("subjectKeyIdentifier too big (expected=%d, actual=%d)", expectedTotalLength, subjectKeyIdentifier.length));
            }
            return Arrays.copyOfRange(subjectKeyIdentifier, 4, 4 + valueLength);
        }
        catch (Exception e) {
            throw new KeyIdentifierSPI.KeyIdentifierSPIException(e);
        }
    }
}

