/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.rm.runtime.sequence.invm;

import com.sun.istack.logging.Logger;
import com.sun.xml.ws.api.ha.HaInfo;
import com.sun.xml.ws.api.ha.HighAvailabilityProvider;
import com.sun.xml.ws.commons.ha.HaContext;
import com.sun.xml.ws.commons.ha.StickyKey;
import com.sun.xml.ws.rx.rm.runtime.sequence.Sequence;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import org.glassfish.ha.store.api.BackingStore;

class SequenceDataPojo
implements Serializable {
    private static final Logger LOGGER = Logger.getLogger(SequenceDataPojo.class);
    static final long serialVersionUID = -5024744406713321676L;
    private transient BackingStore<StickyKey, SequenceDataPojo> backingStore;
    private String sequenceId;
    private String boundSecurityTokenReferenceId;
    private long expirationTime;
    private volatile Sequence.State state;
    private volatile boolean ackRequestedFlag;
    private volatile long lastMessageNumber;
    private volatile long lastActivityTime;
    private volatile long lastAcknowledgementRequestTime;
    private Set<Long> allUnackedMessageNumbers;
    private Set<Long> receivedUnackedMessageNumbers;
    private Set<Long> failedOverUnackedMessageNumbers;
    private Map<Long, String> unackedNumberToCorrelationIdMap;
    private boolean inbound;
    private volatile boolean dirty = false;

    protected SequenceDataPojo() {
    }

    public SequenceDataPojo(String sequenceId, String boundSecurityTokenReferenceId, long expirationTime, boolean isInbound, BackingStore<StickyKey, SequenceDataPojo> bs) {
        this.sequenceId = sequenceId;
        this.boundSecurityTokenReferenceId = boundSecurityTokenReferenceId;
        this.expirationTime = expirationTime;
        this.inbound = isInbound;
        this.allUnackedMessageNumbers = new TreeSet<Long>();
        this.receivedUnackedMessageNumbers = new HashSet<Long>();
        this.failedOverUnackedMessageNumbers = new HashSet<Long>();
        this.unackedNumberToCorrelationIdMap = new HashMap<Long, String>();
        this.backingStore = bs;
    }

    public String getBoundSecurityTokenReferenceId() {
        return this.boundSecurityTokenReferenceId;
    }

    public long getExpirationTime() {
        return this.expirationTime;
    }

    public String getSequenceId() {
        return this.sequenceId;
    }

    public boolean getAckRequestedFlag() {
        return this.ackRequestedFlag;
    }

    public void setAckRequestedFlag(boolean ackRequestedFlag) {
        this.ackRequestedFlag = ackRequestedFlag;
        this.dirty(Parameter.ackRequestedFlag);
    }

    public long getLastAcknowledgementRequestTime() {
        return this.lastAcknowledgementRequestTime;
    }

    public void setLastAcknowledgementRequestTime(long lastAcknowledgementRequestTime) {
        this.lastAcknowledgementRequestTime = lastAcknowledgementRequestTime;
        this.dirty(Parameter.lastAcknowledgementRequestTime);
    }

    public long getLastActivityTime() {
        return this.lastActivityTime;
    }

    public void setLastActivityTime(long lastActivityTime) {
        this.lastActivityTime = lastActivityTime;
        this.dirty(Parameter.lastActivityTime);
    }

    public long getLastMessageNumber() {
        return this.lastMessageNumber;
    }

    public void setLastMessageNumber(long lastMessageNumber) {
        this.lastMessageNumber = lastMessageNumber;
        this.dirty(Parameter.lastMessageNumber);
    }

    public Sequence.State getState() {
        return this.state;
    }

    public void setState(Sequence.State state) {
        this.state = state;
        this.dirty(Parameter.state);
    }

    public Set<Long> getAllUnackedMessageNumbers() {
        return this.allUnackedMessageNumbers;
    }

    public Set<Long> getReceivedUnackedMessageNumbers() {
        return this.receivedUnackedMessageNumbers;
    }

    public Set<Long> getFailedOverUnackedMessageNumbers() {
        return this.failedOverUnackedMessageNumbers;
    }

    public Map<Long, String> getUnackedNumberToCorrelationIdMap() {
        return this.unackedNumberToCorrelationIdMap;
    }

    public boolean isInbound() {
        return this.inbound;
    }

    public void setBackingStore(BackingStore<StickyKey, SequenceDataPojo> backingStore) {
        this.backingStore = backingStore;
    }

    public void replicate() {
        if (this.backingStore != null && this.dirty) {
            HaInfo haInfo = HaContext.currentHaInfo();
            if (haInfo != null) {
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer("Sequence " + this.sequenceId + "]: Existing HaInfo found, using it for sequence state data replication: " + HaContext.asString(haInfo));
                }
                HaContext.udpateReplicaInstance(HighAvailabilityProvider.saveTo(this.backingStore, new StickyKey((Serializable)((Object)this.sequenceId), haInfo.getKey()), this, false));
            } else {
                StickyKey stickyKey = new StickyKey((Serializable)((Object)this.sequenceId));
                String replicaId = HighAvailabilityProvider.saveTo(this.backingStore, stickyKey, this, false);
                haInfo = new HaInfo(stickyKey.getHashKey(), replicaId, false);
                HaContext.updateHaInfo(haInfo);
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer("Sequence " + this.sequenceId + "]: No HaInfo found, created new after sequence state data replication: " + HaContext.asString(haInfo));
                }
            }
        }
        this.resetDirty();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SequenceDataPojo other = (SequenceDataPojo)obj;
        if (!Objects.equals(this.sequenceId, other.sequenceId)) {
            return false;
        }
        if (!Objects.equals(this.boundSecurityTokenReferenceId, other.boundSecurityTokenReferenceId)) {
            return false;
        }
        if (this.expirationTime != other.expirationTime) {
            return false;
        }
        if (this.state != other.state) {
            return false;
        }
        if (this.ackRequestedFlag != other.ackRequestedFlag) {
            return false;
        }
        if (this.lastMessageNumber != other.lastMessageNumber) {
            return false;
        }
        if (this.lastActivityTime != other.lastActivityTime) {
            return false;
        }
        if (this.lastAcknowledgementRequestTime != other.lastAcknowledgementRequestTime) {
            return false;
        }
        if (!Objects.equals(this.allUnackedMessageNumbers, other.allUnackedMessageNumbers)) {
            return false;
        }
        if (!Objects.equals(this.receivedUnackedMessageNumbers, other.receivedUnackedMessageNumbers)) {
            return false;
        }
        if (!Objects.equals(this.unackedNumberToCorrelationIdMap, other.unackedNumberToCorrelationIdMap)) {
            return false;
        }
        return this.inbound == other.inbound;
    }

    public int hashCode() {
        int hash = 7;
        hash = 61 * hash + (this.sequenceId != null ? this.sequenceId.hashCode() : 0);
        hash = 61 * hash + (this.boundSecurityTokenReferenceId != null ? this.boundSecurityTokenReferenceId.hashCode() : 0);
        hash = 61 * hash + (int)(this.expirationTime ^ this.expirationTime >>> 32);
        hash = 61 * hash + (this.state != null ? this.state.hashCode() : 0);
        hash = 61 * hash + (this.ackRequestedFlag ? 1 : 0);
        hash = 61 * hash + (int)(this.lastMessageNumber ^ this.lastMessageNumber >>> 32);
        hash = 61 * hash + (int)(this.lastActivityTime ^ this.lastActivityTime >>> 32);
        hash = 61 * hash + (int)(this.lastAcknowledgementRequestTime ^ this.lastAcknowledgementRequestTime >>> 32);
        hash = 61 * hash + (this.allUnackedMessageNumbers != null ? this.allUnackedMessageNumbers.hashCode() : 0);
        hash = 61 * hash + (this.receivedUnackedMessageNumbers != null ? this.receivedUnackedMessageNumbers.hashCode() : 0);
        hash = 61 * hash + (this.failedOverUnackedMessageNumbers != null ? this.failedOverUnackedMessageNumbers.hashCode() : 0);
        hash = 61 * hash + (this.unackedNumberToCorrelationIdMap != null ? this.unackedNumberToCorrelationIdMap.hashCode() : 0);
        hash = 61 * hash + (this.inbound ? 1 : 0);
        return hash;
    }

    public String toString() {
        return "SequenceDataPojo{\n\tbackingStore=" + String.valueOf(this.backingStore) + ",\n\tsequenceId=" + this.sequenceId + ",\n\tboundSecurityTokenReferenceId=" + this.boundSecurityTokenReferenceId + ",\n\texpirationTime=" + this.expirationTime + ",\n\tstate=" + String.valueOf((Object)this.state) + ",\n\tackRequestedFlag=" + this.ackRequestedFlag + ",\n\tlastMessageNumber=" + this.lastMessageNumber + ",\n\tlastActivityTime=" + this.lastActivityTime + ",\n\tlastAcknowledgementRequestTime=" + this.lastAcknowledgementRequestTime + ",\n\tallUnackedMessageNumbers=" + String.valueOf(this.allUnackedMessageNumbers) + ",\n\treceivedUnackedMessageNumbers=" + String.valueOf(this.receivedUnackedMessageNumbers) + ",\n\tfailedOverUnackedMessageNumbers=" + String.valueOf(this.failedOverUnackedMessageNumbers) + ",\n\tunackedNumberToCorrelationIdMap=" + String.valueOf(this.unackedNumberToCorrelationIdMap) + ",\n\tinbound=" + this.inbound + ",\n\tdirty=" + this.dirty + "\n}";
    }

    private void dirty(Parameter p) {
        this.dirty = true;
    }

    public void resetDirty() {
        this.dirty = false;
    }

    private static enum Parameter {
        sequenceId("sequenceId", 0),
        boundSecurityTokenReferenceId("boundSecurityTokenReferenceId", 1),
        expirationTime("expirationTime", 2),
        state("state", 3),
        ackRequestedFlag("ackRequestedFlag", 4),
        lastMessageNumber("lastMessageNumber", 5),
        lastActivityTime("lastActivityTime", 6),
        lastAcknowledgementRequestTime("lastAcknowledgementRequestTime", 7),
        allUnackedMessageNumbers("allUnackedMessageNumbers", 8),
        receivedUnackedMessageNumbers("receivedUnackedMessageNumbers", 9),
        failedOverUnackedMessageNumbers("failedOverUnackedMessageNumbers", 10),
        unackedNumberToCorrelationIdMap("unackedNumberToCorrelationIdMap", 11),
        inbound("inbound", 12);

        public final String name;
        public final int index;

        private Parameter(String name, int index) {
            this.name = name;
            this.index = index;
        }
    }
}

