/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.transport.tcp.server;

import com.sun.istack.NotNull;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.server.PortAddressResolver;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.transport.http.DeploymentDescriptorParser;
import com.sun.xml.ws.transport.tcp.server.TCPAdapter;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;

public final class TCPAdapterList
extends AbstractList<TCPAdapter>
implements DeploymentDescriptorParser.AdapterFactory<TCPAdapter> {
    private final List<TCPAdapter> adapters = new ArrayList<TCPAdapter>();
    private final Map<PortInfo, String> addressMap = new HashMap<PortInfo, String>();

    @Override
    public TCPAdapter createAdapter(String name, String urlPattern, WSEndpoint<?> endpoint) {
        TCPAdapter tcpAdapter = new TCPAdapter(name, urlPattern, endpoint);
        this.adapters.add(tcpAdapter);
        WSDLPort port = endpoint.getPort();
        if (port != null) {
            PortInfo portInfo = new PortInfo(port.getOwner().getName(), port.getName().getLocalPart(), endpoint.getImplementationClass());
            this.addressMap.put(portInfo, this.getValidPath(urlPattern));
        }
        return tcpAdapter;
    }

    private String getValidPath(@NotNull String urlPattern) {
        if (urlPattern.endsWith("/*")) {
            return urlPattern.substring(0, urlPattern.length() - 2);
        }
        return urlPattern;
    }

    protected PortAddressResolver createPortAddressResolver(final String baseAddress, final Class<?> endpointImpl) {
        return new PortAddressResolver(){

            @Override
            public String getAddressFor(@NotNull QName serviceName, @NotNull String portName) {
                String urlPattern = TCPAdapterList.this.addressMap.get(new PortInfo(serviceName, portName, endpointImpl));
                if (urlPattern == null) {
                    for (Map.Entry<PortInfo, String> e : TCPAdapterList.this.addressMap.entrySet()) {
                        if (!serviceName.equals(e.getKey().serviceName) || !portName.equals(e.getKey().portName)) continue;
                        urlPattern = e.getValue();
                        break;
                    }
                }
                return urlPattern == null ? null : baseAddress + urlPattern;
            }
        };
    }

    @Override
    public TCPAdapter get(int index) {
        return this.adapters.get(index);
    }

    @Override
    public int size() {
        return this.adapters.size();
    }

    private static class PortInfo {
        private final QName serviceName;
        private final String portName;
        private final Class<?> implClass;

        PortInfo(@NotNull QName serviceName, @NotNull String portName, Class<?> implClass) {
            this.serviceName = serviceName;
            this.portName = portName;
            this.implClass = implClass;
        }

        public boolean equals(Object portInfo) {
            if (portInfo instanceof PortInfo) {
                PortInfo that = (PortInfo)portInfo;
                if (this.implClass == null) {
                    return this.serviceName.equals(that.serviceName) && this.portName.equals(that.portName) && that.implClass == null;
                }
                return this.serviceName.equals(that.serviceName) && this.portName.equals(that.portName) && this.implClass.equals(that.implClass);
            }
            return false;
        }

        public int hashCode() {
            int retVal = this.serviceName.hashCode() + this.portName.hashCode();
            return this.implClass != null ? retVal + this.implClass.hashCode() : retVal;
        }
    }
}

