/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.core.reference;

import java.security.cert.X509Certificate;

public abstract class KeyIdentifierSPI {
    public static final String vmVendor = System.getProperty("java.vendor.url");
    public static final String sunVmVendor = "http://java.sun.com/";
    public static final String ibmVmVendor = "http://www.ibm.com/";
    public static final boolean isSunVM = "http://java.sun.com/".equals(vmVendor);
    public static final boolean isIBMVM = "http://www.ibm.com/".equals(vmVendor);
    private static final String sunKeyIdentifierSPIClass = "com.sun.wsit.security.SunKeyIdentifierSPI";
    private static final String ibmKeyIdentifierSPIClass = "com.sun.wsit.security.IBMKeyIdentifierSPI";
    private static final String sunKeyIdentifierImplClass = "sun.security.x509.KeyIdentifier";
    private static final String ibmKeyIdentifierImplClass = "com.ibm.security.x509.KeyIdentifier";
    protected static final String SUBJECT_KEY_IDENTIFIER_OID = "2.5.29.14";
    private static final KeyIdentifierSPI instance;

    protected KeyIdentifierSPI() {
    }

    public static KeyIdentifierSPI getInstance() {
        return instance;
    }

    private static boolean testClassExist(String className) {
        try {
            Class<?> spiClass = null;
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader != null) {
                spiClass = classLoader.loadClass(className);
            }
            if (spiClass == null) {
                spiClass = Class.forName(className);
            }
            return spiClass != null;
        }
        catch (Exception x) {
            return false;
        }
    }

    private static KeyIdentifierSPI loadClass(String className) {
        try {
            Class<?> spiClass = null;
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader != null) {
                spiClass = classLoader.loadClass(className);
            }
            if (spiClass == null) {
                spiClass = Class.forName(className);
            }
            return (KeyIdentifierSPI)spiClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException x) {
            throw new RuntimeException("The KeyIdentifierSPI class: " + className + " specified was not found", x);
        }
        catch (Exception x) {
            throw new RuntimeException("The KeyIdentifierSPI class: " + className + " could not be instantiated ", x);
        }
    }

    public abstract byte[] getSubjectKeyIdentifier(X509Certificate var1) throws KeyIdentifierSPIException;

    static {
        if (isSunVM) {
            instance = KeyIdentifierSPI.loadClass(sunKeyIdentifierSPIClass);
        } else if (isIBMVM) {
            instance = KeyIdentifierSPI.loadClass(ibmKeyIdentifierSPIClass);
        } else if (KeyIdentifierSPI.testClassExist(sunKeyIdentifierImplClass)) {
            instance = KeyIdentifierSPI.loadClass(sunKeyIdentifierSPIClass);
        } else if (KeyIdentifierSPI.testClassExist(ibmKeyIdentifierImplClass)) {
            instance = KeyIdentifierSPI.loadClass(ibmKeyIdentifierSPIClass);
        } else {
            throw new UnsupportedOperationException("KeyIdentifierSPI Error : No known implementation for VM: " + vmVendor);
        }
    }

    protected static final class KeyIdentifierSPIException
    extends Exception {
        private static final long serialVersionUID = -9207910312279723431L;

        public KeyIdentifierSPIException(Exception ex) {
            this.initCause(ex);
        }
    }
}

