/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.cluster;

import com.sun.enterprise.admin.remote.RemoteRestAdminCommand;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.v3.admin.AdminCommandJob;
import com.sun.enterprise.v3.admin.adapter.AdminEndpointDecider;
import com.sun.enterprise.v3.admin.cluster.CommandRunnable;
import com.sun.enterprise.v3.admin.cluster.Strings;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandInvocation;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.ProgressStatus;
import org.glassfish.embeddable.GlassFishVariable;

class ClusterCommandHelper {
    private static final System.Logger LOG = System.getLogger(ClusterCommandHelper.class.getName());
    private static final String NL = System.lineSeparator();
    private Domain domain;
    private CommandRunner<AdminCommandJob> runner;
    private ProgressStatus progress;

    ClusterCommandHelper(Domain domain, CommandRunner<AdminCommandJob> runner) {
        this.domain = domain;
        this.runner = runner;
    }

    ActionReport runCommand(final String command, ParameterMap map, final String clusterName, AdminCommandContext context, boolean debug, boolean verbose, Duration timeout) throws CommandException {
        ActionReport report = context.getActionReport();
        Cluster cluster = this.domain.getClusterNamed(clusterName);
        if (cluster == null) {
            String msg = Strings.get("cluster.command.unknownCluster", clusterName);
            throw new CommandException(msg);
        }
        List targetServers = this.domain.getServersInTarget(clusterName);
        if (targetServers == null || targetServers.isEmpty()) {
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
            report.setMessage(Strings.get("cluster.command.noInstances", clusterName));
            return report;
        }
        int nInstances = targetServers.size();
        StringBuilder failedServerNames = new StringBuilder();
        StringBuilder succeededServerNames = new StringBuilder();
        ArrayList<String> waitingForServerNames = new ArrayList<String>();
        ReportResult reportResult = new ReportResult();
        boolean failureOccurred = false;
        this.progress = context.getProgressStatus();
        StringBuilder output = new StringBuilder();
        LOG.log(System.Logger.Level.DEBUG, () -> "Instance list " + ClusterCommandHelper.serverListToString(targetServers));
        if (map == null) {
            map = new ParameterMap();
        }
        ThreadFactory threadFactory = new ThreadFactory(){
            private final AtomicInteger id = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, "ClusterCommandHelper-" + command + "-" + clusterName + "-" + this.id.incrementAndGet());
                t.setDaemon(true);
                return t;
            }
        };
        int threadPoolSize = this.getAdminThreadPoolSize(LOG);
        ExecutorService executor = Executors.newFixedThreadPool(threadPoolSize, threadFactory);
        LOG.log(System.Logger.Level.INFO, String.format("Executing %s on %d instances using a thread pool of size %d: %s", command, nInstances, threadPoolSize, ClusterCommandHelper.serverListToString(targetServers)));
        this.progress.setTotalStepCount(nInstances);
        this.progress.progress(Strings.get("cluster.command.executing", command, nInstances));
        ArrayBlockingQueue<CommandRunnable> responseQueue = new ArrayBlockingQueue<CommandRunnable>(nInstances);
        for (Server server : targetServers) {
            String iname = server.getName();
            waitingForServerNames.add(iname);
            ParameterMap instanceParameterMap = new ParameterMap(map);
            instanceParameterMap.set((Object)"DEFAULT", (Object)iname);
            if (debug) {
                instanceParameterMap.set((Object)"debug", (Object)"true");
            }
            ActionReport instanceReport = this.runner.getActionReport("plain");
            instanceReport.setActionExitCode(ActionReport.ExitCode.SUCCESS);
            CommandInvocation invocation = this.runner.getCommandInvocation(command, instanceReport, context.getSubject());
            invocation.parameters(instanceParameterMap);
            String msg = command + " " + iname;
            LOG.log(System.Logger.Level.INFO, msg);
            if (verbose) {
                output.append(msg).append(NL);
            }
            CommandRunnable cmdRunnable = new CommandRunnable(iname, invocation, instanceReport, responseQueue);
            CompletableFuture.runAsync(cmdRunnable, executor);
        }
        LOG.log(System.Logger.Level.DEBUG, () -> "Started commands in parallel, waiting for responses...");
        long deadline = this.computeDeadline(timeout);
        for (int i = 0; i < nInstances; ++i) {
            long timeLeft = deadline - System.currentTimeMillis();
            CommandRunnable cmdRunnable = null;
            try {
                cmdRunnable = (CommandRunnable)responseQueue.poll(timeLeft, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                executor.shutdownNow();
                String msg = Strings.get("cluster.command.interrupted", clusterName, i, Integer.toString(nInstances), command);
                LOG.log(System.Logger.Level.WARNING, msg);
                output.append(msg).append(NL);
                failureOccurred = true;
                Thread.currentThread().interrupt();
                break;
            }
            if (cmdRunnable == null) break;
            String iname = cmdRunnable.getName();
            waitingForServerNames.remove(iname);
            ActionReport instanceReport = cmdRunnable.getActionReport();
            LOG.log(System.Logger.Level.DEBUG, String.format("Instance %d of %d (%s) has responded with %s", i + 1, nInstances, iname, instanceReport.getActionExitCode()));
            if (instanceReport.getActionExitCode() != ActionReport.ExitCode.SUCCESS) {
                failureOccurred = true;
                failedServerNames.append(iname).append(" ");
                reportResult.failedServerNames.add(iname);
                String msg = iname + ": " + instanceReport.getMessage();
                LOG.log(System.Logger.Level.ERROR, msg);
                output.append(msg).append(NL);
                this.progress.progress(1, Strings.get("cluster.command.instancesFailed", command, iname));
                continue;
            }
            succeededServerNames.append(iname).append(" ");
            reportResult.succeededServerNames.add(iname);
            this.progress.progress(1, iname);
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        if (failureOccurred) {
            report.setResultType(List.class, reportResult.failedServerNames);
        } else {
            report.setResultType(List.class, reportResult.succeededServerNames);
        }
        if (succeededServerNames.length() > 0 && (verbose || failureOccurred)) {
            output.append(NL).append(Strings.get("cluster.command.instancesSucceeded", command, succeededServerNames));
        }
        if (failureOccurred) {
            output.append(NL).append(Strings.get("cluster.command.instancesFailed", command, failedServerNames));
            if (succeededServerNames.length() > 0) {
                report.setActionExitCode(ActionReport.ExitCode.WARNING);
            } else {
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            }
        }
        if (!waitingForServerNames.isEmpty()) {
            String msg = Strings.get("cluster.command.instancesTimedOut", command, ClusterCommandHelper.listToString(waitingForServerNames));
            LOG.log(System.Logger.Level.WARNING, msg);
            if (output.length() > 0) {
                output.append(NL);
            }
            output.append(msg);
            report.setActionExitCode(ActionReport.ExitCode.WARNING);
        }
        report.setMessage(output.toString());
        executor.shutdown();
        return report;
    }

    private long computeDeadline(Duration timeoutParameter) {
        long timeout;
        long adminTimeout = RemoteRestAdminCommand.getReadTimeout() - 2000;
        if (adminTimeout <= 0L) {
            timeout = timeoutParameter.toMillis();
        } else if (timeoutParameter.toMillis() > adminTimeout) {
            LOG.log(System.Logger.Level.WARNING, "Cluster command timeout is greater than admin read timeout. Using admin read timeout instead to prevent socket read timeouts.");
            timeout = adminTimeout;
        } else {
            timeout = timeoutParameter.toMillis();
        }
        return System.currentTimeMillis() + timeout;
    }

    private int getAdminThreadPoolSize(System.Logger logger) {
        Config config = this.domain.getConfigNamed("server-config");
        if (config == null) {
            return 10;
        }
        AdminEndpointDecider aed = new AdminEndpointDecider(config);
        return aed.getMaxThreadPoolSize();
    }

    private static String serverListToString(List<Server> servers) {
        StringBuilder sb = new StringBuilder();
        for (Server s : servers) {
            sb.append(s.getNodeRef()).append(':').append(s.getName()).append(' ');
        }
        return sb.toString().trim();
    }

    private static String listToString(List<String> slist) {
        StringBuilder sb = new StringBuilder();
        for (String s : slist) {
            sb.append(s).append(' ');
        }
        return sb.toString().trim();
    }

    static Duration getTimeout(Integer timeout, GlassFishVariable envVariable) {
        if (timeout == null) {
            String envValue = System.getenv(envVariable.getEnvName());
            if (envValue == null) {
                return Duration.ofSeconds(60L);
            }
            return Duration.ofSeconds(Long.parseLong(envValue));
        }
        return Duration.ofSeconds(timeout.intValue());
    }

    public static class ReportResult {
        public final List<String> succeededServerNames = new ArrayList<String>();
        public final List<String> failedServerNames = new ArrayList<String>();
    }
}

