/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.osgi.cli.interactive;

import com.sun.enterprise.admin.cli.ArgumentTokenizer;
import com.sun.enterprise.admin.cli.CLICommand;
import com.sun.enterprise.admin.cli.CLIUtil;
import com.sun.enterprise.admin.cli.Environment;
import com.sun.enterprise.admin.cli.MultimodeCommand;
import com.sun.enterprise.admin.cli.ProgramOptions;
import com.sun.enterprise.admin.cli.remote.RemoteCLICommand;
import com.sun.enterprise.admin.util.CommandModelData;
import jakarta.inject.Inject;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.logging.Level;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandModel;
import org.glassfish.api.admin.CommandValidationException;
import org.glassfish.common.util.io.EmptyOutputStream;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.DynamicConfiguration;
import org.glassfish.hk2.api.DynamicConfigurationService;
import org.glassfish.hk2.api.Filter;
import org.glassfish.hk2.api.MultiException;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.utilities.AbstractActiveDescriptor;
import org.glassfish.hk2.utilities.BuilderHelper;
import org.glassfish.main.jdke.i18n.LocalStringsImpl;
import org.glassfish.main.jdke.props.SystemProperties;
import org.jline.reader.Completer;
import org.jline.reader.EndOfFileException;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.impl.completer.NullCompleter;
import org.jline.reader.impl.completer.StringsCompleter;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import org.jline.terminal.impl.ExternalTerminal;
import org.jvnet.hk2.annotations.Service;

@Service(name="osgi-shell")
@I18n(value="osgi-shell")
@PerLookup
public class LocalOSGiShellCommand
extends CLICommand {
    private static final String REMOTE_COMMAND = "osgi";
    private static final String SESSIONID_OPTION = "--session-id";
    private static final String SESSION_OPTION = "--session";
    private static final String SESSION_OPTION_EXECUTE = "execute";
    private static final String SESSION_OPTION_START = "new";
    private static final String SESSION_OPTION_STOP = "stop";
    private static final LocalStringsImpl STRINGS = new LocalStringsImpl(MultimodeCommand.class);
    @Inject
    private ServiceLocator locator;
    @Param(name="instance", optional=true)
    private String instance;
    @Param(optional=true, shortName="f")
    private File file;
    @Param(name="printprompt", optional=true)
    private Boolean printPromptOpt;
    @Param(optional=true)
    private String encoding;
    private boolean echo;
    private RemoteCLICommand cmd;
    private String shellType;

    public void postConstruct() {
        super.postConstruct();
        try {
            this.cmd = new RemoteCLICommand(REMOTE_COMMAND, (ProgramOptions)this.locator.getService(ProgramOptions.class, new Annotation[0]), (Environment)this.locator.getService(Environment.class, new Annotation[0]));
        }
        catch (CommandException | MultiException e) {
            logger.log(Level.SEVERE, "postConstruct failed!", e);
        }
    }

    protected void validate() {
        this.echo = this.programOpts.isEcho();
    }

    protected Collection<CommandModel.ParamModel> usageOptions() {
        Collection opts = this.commandModel.getParameters();
        LinkedHashSet<CommandModel.ParamModel> uopts = new LinkedHashSet<CommandModel.ParamModel>();
        String interactive = Boolean.toString(this.programOpts.isInteractive());
        CommandModelData.ParamModelData p = new CommandModelData.ParamModelData("printprompt", Boolean.TYPE, true, interactive);
        for (CommandModel.ParamModel pm : opts) {
            if (pm.getName().equals("printprompt")) {
                uopts.add((CommandModel.ParamModel)p);
                continue;
            }
            uopts.add(pm);
        }
        return uopts;
    }

    protected int executeCommand() throws CommandException {
        int n;
        block11: {
            if (this.cmd == null) {
                throw new CommandException("Remote command 'osgi' is not available.");
            }
            this.programOpts.setEcho(this.echo);
            if (this.encoding != null) {
                SystemProperties.setProperty((String)"input.encoding", (String)this.encoding, (boolean)true);
            }
            Object[] args = this.enhanceForTarget(new String[]{REMOTE_COMMAND, "asadmin-osgi-shell"});
            logger.log(Level.FINEST, "executeCommand: args {0}", Arrays.toString(args));
            this.shellType = this.cmd.executeAndReturnOutput((String[])args).trim();
            Terminal terminal = this.createTerminal();
            try {
                LineReaderBuilder builder = LineReaderBuilder.builder().appName(REMOTE_COMMAND).terminal(terminal);
                if (this.isInteractive()) {
                    builder.completer(this.getCommandCompleter());
                    builder.option(LineReader.Option.INSERT_TAB, false);
                }
                n = this.executeCommands(builder.build());
                if (terminal == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (terminal != null) {
                        try {
                            terminal.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new CommandException((Throwable)e);
                }
            }
            terminal.close();
        }
        return n;
    }

    private String[] enhanceForTarget(String[] args) {
        if (this.instance == null) {
            return args;
        }
        String[] targetArgs = new String[args.length + 2];
        targetArgs[1] = "--instance";
        targetArgs[2] = this.instance;
        System.arraycopy(args, 0, targetArgs, 0, 1);
        System.arraycopy(args, 1, targetArgs, 3, args.length - 1);
        return targetArgs;
    }

    private Terminal createTerminal() throws IOException, CommandException {
        if (!this.isInteractive()) {
            if (!this.file.canRead()) {
                throw new CommandException("File: " + String.valueOf(this.file) + " can not be read");
            }
            Charset charset = this.encoding == null ? Charset.defaultCharset() : Charset.forName(this.encoding);
            return new ExternalTerminal(REMOTE_COMMAND, "dumb", new FileInputStream(this.file), (OutputStream)new EmptyOutputStream(), charset);
        }
        System.out.println(STRINGS.get("multimodeIntro"));
        return TerminalBuilder.builder().system(true).build();
    }

    private Completer getCommandCompleter() {
        if ("gogo".equals(this.shellType)) {
            return new StringsCompleter("bundlelevel", "cd", "frameworklevel", "headers", "help", "inspect", "install", "lb", "log", "ls", "refresh", "resolve", "start", SESSION_OPTION_STOP, "uninstall", "update", "which", "cat", "each", "echo", "format", "getopt", "gosh", "grep", "not", "set", "sh", "source", "tac", "telnetd", "type", "until", "deploy", "info", "javadoc", "list", "repos", "source");
        }
        if ("felix".equals(this.shellType)) {
            return new StringsCompleter("exit", "quit", "help", "bundlelevel", "cd", "find", "headers", "inspect", "install", "log", "ps", "refresh", "resolve", "scr", "shutdown", "start", "startlevel", SESSION_OPTION_STOP, "sysprop", "uninstall", "update", "version");
        }
        return new NullCompleter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int executeCommands(LineReader reader) throws CommandException {
        int rc = 0;
        this.programOpts.toEnvironment(this.env);
        String sessionId = this.startSession();
        try {
            while (true) {
                String[] args;
                String line;
                try {
                    line = this.isInteractive() ? reader.readLine(this.shellType + "$ ") : reader.readLine();
                }
                catch (EndOfFileException e) {
                    break;
                }
                if (line == null || line.isBlank() || line.trim().startsWith("#")) continue;
                try {
                    args = LocalOSGiShellCommand.getArgs(line);
                }
                catch (ArgumentTokenizer.ArgumentException ex) {
                    logger.severe(ex.getMessage());
                    continue;
                }
                String command = args[0];
                if ("exit".equals(command)) break;
                if ("quit".equals(command)) {
                    break;
                }
                String[] arguments = this.enhanceForTarget(this.prepareArguments(sessionId, args));
                try {
                    ProgramOptions programOptions = new ProgramOptions(this.env);
                    programOptions.setModulePath(this.programOpts.getModulePath());
                    programOptions.setClassPath(this.programOpts.getClassPath());
                    programOptions.setClassName(this.programOpts.getClassName());
                    LocalOSGiShellCommand.atomicReplace(this.locator, programOptions);
                    String output = this.cmd.executeAndReturnOutput(arguments).trim();
                    if (output != null && !output.isEmpty()) {
                        logger.info(output);
                    }
                }
                catch (CommandValidationException cve) {
                    logger.severe(cve.getMessage());
                    logger.severe(this.cmd.getUsage());
                    rc = 1;
                }
                catch (CommandException ce) {
                    logger.severe(ce.getMessage());
                    rc = 1;
                }
                finally {
                    LocalOSGiShellCommand.atomicReplace(this.locator, this.programOpts);
                }
                CLIUtil.writeCommandToDebugLog((String)this.name, (Environment)this.env, (String[])arguments, (int)rc);
            }
        }
        finally {
            rc = this.stopSession(sessionId);
        }
        return rc;
    }

    private String[] prepareArguments(String sessionId, String[] args) {
        if (sessionId == null) {
            String[] osgiArgs = args == null ? new String[1] : new String[args.length + 1];
            osgiArgs[0] = REMOTE_COMMAND;
            if (args != null && args.length > 0) {
                System.arraycopy(args, 0, osgiArgs, 1, args.length);
            }
            return osgiArgs;
        }
        String[] sessionArgs = args == null ? new String[5] : new String[args.length + 5];
        sessionArgs[0] = REMOTE_COMMAND;
        sessionArgs[1] = SESSION_OPTION;
        sessionArgs[2] = SESSION_OPTION_EXECUTE;
        sessionArgs[3] = SESSIONID_OPTION;
        sessionArgs[4] = sessionId;
        if (args != null && args.length > 0) {
            System.arraycopy(args, 0, sessionArgs, 5, args.length);
        }
        return sessionArgs;
    }

    private String startSession() throws CommandException {
        if (!"gogo".equals(this.shellType)) {
            return null;
        }
        String[] args = new String[]{REMOTE_COMMAND, SESSION_OPTION, SESSION_OPTION_START};
        return this.cmd.executeAndReturnOutput(this.enhanceForTarget(args)).trim();
    }

    private int stopSession(String sessionId) throws CommandException {
        if (sessionId == null) {
            return 0;
        }
        String[] args = new String[]{REMOTE_COMMAND, SESSION_OPTION, SESSION_OPTION_STOP, SESSIONID_OPTION, sessionId};
        return this.cmd.execute(this.enhanceForTarget(args));
    }

    private boolean isInteractive() {
        return this.file == null;
    }

    private static void atomicReplace(ServiceLocator locator, ProgramOptions options) {
        DynamicConfigurationService dcs = (DynamicConfigurationService)locator.getService(DynamicConfigurationService.class, new Annotation[0]);
        DynamicConfiguration config = dcs.createDynamicConfiguration();
        config.addUnbindFilter((Filter)BuilderHelper.createContractFilter((String)ProgramOptions.class.getName()));
        AbstractActiveDescriptor desc = BuilderHelper.createConstantDescriptor((Object)options, null, (Type[])new Type[]{ProgramOptions.class});
        config.addActiveDescriptor((ActiveDescriptor)desc);
        config.commit();
    }

    private static String[] getArgs(String line) throws ArgumentTokenizer.ArgumentException {
        ArrayList<String> args = new ArrayList<String>();
        ArgumentTokenizer t = new ArgumentTokenizer(line);
        while (t.hasMoreTokens()) {
            args.add(t.nextToken());
        }
        return (String[])args.toArray(String[]::new);
    }
}

